/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.ui.playback.commands.KeyStokeMap;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Robot;
import javax.swing.KeyStroke;

public abstract class TypeCommand
extends AbstractCommand {
    private static KeyStokeMap ourMap = new KeyStokeMap();

    public TypeCommand(String text, int line) {
        super(text, line);
    }

    protected void type(Robot robot, int code, int modfiers) {
        this.type(robot, KeyStroke.getKeyStroke(code, modfiers));
    }

    protected void type(Robot robot, KeyStroke keyStroke) {
        boolean meta;
        boolean shift = (keyStroke.getModifiers() & 1) > 0;
        boolean alt = (keyStroke.getModifiers() & 8) > 0;
        boolean control = (keyStroke.getModifiers() & 2) > 0;
        boolean bl = meta = (keyStroke.getModifiers() & 4) > 0;
        if (shift) {
            robot.keyPress(16);
        }
        if (control) {
            robot.keyPress(17);
        }
        if (alt) {
            robot.keyPress(18);
        }
        if (meta) {
            robot.keyPress(157);
        }
        if (keyStroke.getKeyCode() > 0) {
            robot.keyPress(keyStroke.getKeyCode());
            robot.delay(Registry.intValue((String)"actionSystem.playback.autodelay"));
            robot.keyRelease(keyStroke.getKeyCode());
        } else {
            robot.keyPress(keyStroke.getKeyChar());
            robot.delay(Registry.intValue((String)"actionSystem.playback.autodelay"));
            robot.keyRelease(keyStroke.getKeyChar());
        }
        if (shift) {
            robot.keyRelease(16);
        }
        if (control) {
            robot.keyRelease(17);
        }
        if (alt) {
            robot.keyRelease(18);
        }
        if (meta) {
            robot.keyRelease(157);
        }
    }

    protected KeyStroke get(char c) {
        return ourMap.get(c);
    }

    protected KeyStroke getFromShortcut(String sc) {
        return ourMap.get(sc);
    }

    public static boolean containsUnicode(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (ourMap.containsChar(s.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

