/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.CommonBundle;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibraryConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.tree.TreeUtil;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseLibrariesConfigurable
extends BaseStructureConfigurable {
    protected String myLevel;

    protected BaseLibrariesConfigurable(Project project) {
        super(project);
    }

    protected void processRemovedItems() {
    }

    protected boolean wasObjectStored(Object editableObject) {
        return false;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settingsdialog.project.structure.library";
    }

    public boolean isModified() {
        boolean isModified = false;
        for (LibrariesModifiableModel provider : this.myContext.myLevel2Providers.values()) {
            isModified |= provider.isChanged();
        }
        return isModified;
    }

    @Override
    public void reset() {
        super.reset();
        this.myTree.setRootVisible(false);
    }

    @Override
    protected void loadTree() {
        this.createLibrariesNode(this.myContext.createModifiableModelProvider(this.myLevel, false));
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<LibraryProjectStructureElement> result = new ArrayList<LibraryProjectStructureElement>();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            NamedConfigurable configurable;
            TreeNode node = this.myRoot.getChildAt(i);
            if (!(node instanceof MasterDetailsComponent.MyNode) || !((configurable = ((MasterDetailsComponent.MyNode)node).getConfigurable()) instanceof LibraryConfigurable)) continue;
            result.add(new LibraryProjectStructureElement(this.myContext, ((LibraryConfigurable)configurable).getEditableObject()));
        }
        ArrayList<LibraryProjectStructureElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable.getProjectStructureElements must not return null");
        }
        return arrayList;
    }

    private void createLibrariesNode(LibraryTableModifiableModelProvider modelProvider) {
        Library[] libraries;
        for (Library library : libraries = modelProvider.getModifiableModel().getLibraries()) {
            this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)new LibraryConfigurable(modelProvider, library, this.myProject, this.TREE_UPDATER)));
        }
        TreeUtil.sort((DefaultMutableTreeNode)this.myRoot, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                MasterDetailsComponent.MyNode node1 = (MasterDetailsComponent.MyNode)o1;
                MasterDetailsComponent.MyNode node2 = (MasterDetailsComponent.MyNode)o2;
                return node1.getDisplayName().compareToIgnoreCase(node2.getDisplayName());
            }
        });
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
    }

    public void apply() throws ConfigurationException {
        super.apply();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (LibrariesModifiableModel provider : BaseLibrariesConfigurable.this.myContext.myLevel2Providers.values()) {
                    provider.deferredCommit();
                }
            }
        });
    }

    public MasterDetailsComponent.MyNode createLibraryNode(Library library) {
        LibraryTable table = library.getTable();
        if (table != null) {
            String level = table.getTableLevel();
            LibraryConfigurable configurable = new LibraryConfigurable(this.myContext.createModifiableModelProvider(level, false), library, this.myProject, this.TREE_UPDATER);
            MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)configurable);
            this.addNode(node, this.myRoot);
            this.myContext.getDaemonAnalyzer().queueUpdate(new LibraryProjectStructureElement(this.myContext, library));
            return node;
        }
        return null;
    }

    public void dispose() {
        for (LibrariesModifiableModel provider : this.myContext.myLevel2Providers.values()) {
            provider.disposeUncommittedLibraries();
        }
    }

    @Override
    protected AnAction createCopyAction() {
        return new MyCopyAction();
    }

    @Override
    protected BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        return new BaseStructureConfigurable.AbstractAddGroup(this.getAddText()){
            {
                this.setPopup(false);
            }

            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                return new AnAction[]{new AnAction(BaseLibrariesConfigurable.this.getAddText()){

                    public void actionPerformed(AnActionEvent e) {
                        LibraryTableEditor editor = LibraryTableEditor.editLibraryTable(BaseLibrariesConfigurable.this.getModelProvider(false), BaseLibrariesConfigurable.this.myProject);
                        editor.addLibraryEditorListener(BaseLibrariesConfigurable.this.myContext);
                        editor.createAddLibraryAction(true).actionPerformed(null);
                        Disposer.dispose((Disposable)editor);
                    }
                }};
            }
        };
    }

    protected abstract String getAddText();

    public abstract LibraryTableModifiableModelProvider getModelProvider(boolean var1);

    public abstract BaseLibrariesConfigurable getOppositeGroup();

    @Override
    protected void removeLibrary(Library library) {
        LibraryTable table = library.getTable();
        if (table != null) {
            this.getModelProvider(true).getModifiableModel().removeLibrary(library);
            this.myContext.getDaemonAnalyzer().removeElement(new LibraryProjectStructureElement(this.myContext, library));
        }
    }

    @Nullable
    protected String getEmptySelectionString() {
        return "Select a library to view or edit its details here";
    }

    private class MyCopyAction
    extends AnAction {
        private JCheckBox mySaveAsCb;
        private JTextField myNameTf;
        private TextFieldWithBrowseButton myPathTf;
        private JPanel myWholePanel;

        private MyCopyAction() {
            super(CommonBundle.message((String)"button.copy", (Object[])new Object[0]), CommonBundle.message((String)"button.copy", (Object[])new Object[0]), COPY_ICON);
            this.$$$setupUI$$$();
        }

        public void actionPerformed(AnActionEvent e) {
            Object o = BaseLibrariesConfigurable.this.getSelectedObject();
            if (o instanceof LibraryImpl) {
                this.myPathTf.addBrowseFolderListener("Choose directory", ProjectBundle.message((String)"directory.roots.copy.label", (Object[])new Object[0]), BaseLibrariesConfigurable.this.myProject, BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR);
                this.mySaveAsCb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MyCopyAction.this.myPathTf.setEnabled(MyCopyAction.this.mySaveAsCb.isSelected());
                    }
                });
                this.mySaveAsCb.setText(ProjectBundle.message((String)"save.as.library.checkbox", (Object[])new Object[]{BaseLibrariesConfigurable.this.getOppositeGroup().myLevel}));
                this.mySaveAsCb.setSelected(false);
                this.myPathTf.setEnabled(false);
                DialogWrapper dlg = new DialogWrapper((Component)BaseLibrariesConfigurable.this.myTree, false){
                    {
                        this.setTitle("Copy");
                        this.init();
                    }

                    @Nullable
                    protected JComponent createCenterPanel() {
                        return MyCopyAction.this.myWholePanel;
                    }

                    public JComponent getPreferredFocusedComponent() {
                        return MyCopyAction.this.myNameTf;
                    }

                    protected void doOKAction() {
                        if (MyCopyAction.this.myNameTf.getText().length() == 0) {
                            Messages.showErrorDialog((String)"Enter library copy name", (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
                            return;
                        }
                        super.doOKAction();
                    }
                };
                dlg.show();
                if (!dlg.isOK()) {
                    return;
                }
                BaseLibrariesConfigurable configurable = this.mySaveAsCb.isSelected() ? BaseLibrariesConfigurable.this.getOppositeGroup() : BaseLibrariesConfigurable.this;
                LibraryImpl library = (LibraryImpl)BaseLibrariesConfigurable.this.myContext.getLibrary(((LibraryImpl)o).getName(), BaseLibrariesConfigurable.this.myLevel);
                LOG.assertTrue(library != null);
                LibraryTable.ModifiableModel libsModel = configurable.getModelProvider(true).getModifiableModel();
                Library lib = libsModel.createLibrary(this.myNameTf.getText());
                Library.ModifiableModel model = ((LibrariesModifiableModel)libsModel).getLibraryEditor(lib).getModel();
                for (OrderRootType type : OrderRootType.getAllTypes()) {
                    VirtualFile[] files;
                    for (VirtualFile file : files = library.getFiles(type)) {
                        if (this.mySaveAsCb.isSelected() && this.myPathTf.getText().trim().length() > 0) {
                            File copy = new File(new File(this.myPathTf.getText()), file.getName());
                            if (!copy.getParentFile().exists() && !copy.getParentFile().mkdirs()) continue;
                            try {
                                File fromFile = VfsUtil.virtualToIoFile((VirtualFile)file);
                                if (fromFile.isFile()) {
                                    FileUtil.copy((File)fromFile, (File)copy);
                                } else {
                                    FileUtil.copyDir((File)fromFile, (File)copy);
                                }
                                model.addRoot(LocalFileSystem.getInstance().refreshAndFindFileByIoFile(copy), type);
                            }
                            catch (IOException e1) {
                                LOG.error((Throwable)e1);
                            }
                            continue;
                        }
                        model.addRoot(file, type);
                    }
                }
            }
        }

        public void update(AnActionEvent e) {
            if (BaseLibrariesConfigurable.this.myTree.getSelectionPaths() == null || BaseLibrariesConfigurable.this.myTree.getSelectionPaths().length != 1) {
                e.getPresentation().setEnabled(false);
            } else {
                e.getPresentation().setEnabled(BaseLibrariesConfigurable.this.getSelectedObject() instanceof LibraryImpl);
            }
        }

        private /* synthetic */ void $$$setupUI$$$() {
            TextFieldWithBrowseButton textFieldWithBrowseButton;
            JCheckBox jCheckBox;
            JTextField jTextField;
            JPanel jPanel;
            this.myWholePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new FormLayout("fill:max(d;4px):noGrow,left:4dlu:noGrow,fill:d:grow,left:4dlu:noGrow", "center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow"));
            jPanel.setPreferredSize(new Dimension(250, 92));
            JLabel jLabel = new JLabel();
            jLabel.setText("Name:");
            jPanel.add((Component)jLabel, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
            this.myNameTf = jTextField = new JTextField();
            jPanel.add((Component)jTextField, new CellConstraints(3, 1, 2, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
            this.mySaveAsCb = jCheckBox = new JCheckBox();
            jCheckBox.setText("");
            jPanel.add((Component)jCheckBox, new CellConstraints(1, 3, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
            this.myPathTf = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
            jPanel.add((Component)textFieldWithBrowseButton, new CellConstraints(1, 7, 4, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 10, 0, 0)));
            JLabel jLabel2 = new JLabel();
            this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ProjectBundle").getString("directory.roots.copy.label"));
            jPanel.add((Component)jLabel2, new CellConstraints(1, 5, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 10, 0, 0)));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

