/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.OrderRootTypeUIFactory;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.AbstractLibraryTreeStructure;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeContentElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;

public class LibraryTreeStructure
extends AbstractLibraryTreeStructure {
    private final LibraryElement myRootElement;

    public LibraryTreeStructure(LibraryTableEditor parentElement, Library library) {
        super(parentElement);
        this.myRootElement = new LibraryElement(library, this.myParentEditor, false);
        this.myRootElementDescriptor = new NodeDescriptor(null, null){

            public boolean update() {
                this.myName = ProjectBundle.message((String)"library.root.node", (Object[])new Object[0]);
                return false;
            }

            public Object getElement() {
                return LibraryTreeStructure.this.myRootElement;
            }
        };
    }

    public Object getRootElement() {
        return this.myRootElement;
    }

    public Object[] getChildElements(Object element) {
        LibraryTableTreeContentElement contentElement;
        LibraryTableTreeContentElement parentElement;
        if (element == this.myRootElement) {
            ArrayList<LibraryTableTreeContentElement> elements = new ArrayList<LibraryTableTreeContentElement>(3);
            Library library = this.myRootElement.getLibrary();
            LibraryEditor parentEditor = this.myParentEditor.getLibraryEditor(library);
            for (OrderRootType type : OrderRootType.getAllTypes()) {
                String[] urls = parentEditor.getUrls(type);
                if (urls.length <= 0) continue;
                elements.add(((OrderRootTypeUIFactory)OrderRootTypeUIFactory.FACTORY.getByKey((Object)type)).createElement(this.myRootElement));
            }
            return elements.toArray();
        }
        if (element instanceof LibraryTableTreeContentElement && (parentElement = (contentElement = (LibraryTableTreeContentElement)element).getParent()) instanceof LibraryElement) {
            return this.buildItems(contentElement, ((LibraryElement)parentElement).getLibrary(), contentElement.getOrderRootType());
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public Library getLibrary() {
        return this.myRootElement.getLibrary();
    }
}

