/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableEditor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Icons;
import java.awt.Color;
import java.io.File;
import javax.swing.Icon;

class LibraryElementDescriptor
extends NodeDescriptor<LibraryElement> {
    private final LibraryElement myElement;
    private final LibraryTableEditor myParentEditor;

    public LibraryElementDescriptor(NodeDescriptor parentDescriptor, LibraryElement element, LibraryTableEditor parentEditor) {
        super(null, parentDescriptor);
        this.myElement = element;
        this.myParentEditor = parentEditor;
    }

    public boolean update() {
        boolean changed;
        Icon icon;
        String name;
        Library library = this.myElement.getLibrary();
        LibraryEditor libraryEditor = this.myParentEditor.getLibraryEditor(library);
        if (this.myElement.isAnonymous()) {
            VirtualFile[] files = libraryEditor.getFiles(OrderRootType.CLASSES);
            if (files.length > 0) {
                name = files[0].getPresentableUrl();
                String url = files[0].getUrl();
                icon = LibraryTableEditor.getIconForUrl(url, true, libraryEditor.isJarDirectory(url));
            } else {
                String[] urls = libraryEditor.getUrls(OrderRootType.CLASSES);
                if (urls.length > 0) {
                    String url = urls[0];
                    name = LibraryTableEditor.getPresentablePath(url).replace('/', File.separatorChar);
                    icon = LibraryTableEditor.getIconForUrl(url, false, libraryEditor.isJarDirectory(url));
                } else {
                    name = ProjectBundle.message((String)"library.empty.item", (Object[])new Object[0]);
                    icon = Icons.LIBRARY_ICON;
                }
            }
        } else {
            name = libraryEditor.getName();
            icon = Icons.LIBRARY_ICON;
        }
        this.myColor = this.myElement.hasInvalidPaths() ? Color.RED : null;
        boolean bl = changed = !name.equals(this.myName) || !icon.equals(this.myClosedIcon);
        if (changed) {
            this.myName = name;
            this.myClosedIcon = this.myOpenIcon = icon;
        }
        return changed;
    }

    public LibraryElement getElement() {
        return this.myElement;
    }
}

