/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TitlePanel;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Icons;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class DetectedSourceRootsDialog
extends DialogWrapper {
    private final CheckboxTree myTree;
    private final CheckedTreeNode myRootNode;
    private final JScrollPane myPane;

    public DetectedSourceRootsDialog(Project project, List<VirtualFile> detectedRoots, VirtualFile baseRoot) {
        this(project, DetectedSourceRootsDialog.createTree(baseRoot, detectedRoots));
    }

    public DetectedSourceRootsDialog(Project project, Map<VirtualFile, List<VirtualFile>> detectedRoots) {
        this(project, DetectedSourceRootsDialog.createTree(detectedRoots));
    }

    public DetectedSourceRootsDialog(Component component, Map<VirtualFile, List<VirtualFile>> detectedRoots) {
        this(component, DetectedSourceRootsDialog.createTree(detectedRoots));
    }

    private DetectedSourceRootsDialog(Project project, CheckedTreeNode tree) {
        super(project, true);
        this.myRootNode = tree;
        this.myTree = this.createCheckboxTree();
        this.myPane = new JScrollPane((Component)((Object)this.myTree));
        this.setTitle("Detected Source Roots");
        this.init();
    }

    private DetectedSourceRootsDialog(Component component, CheckedTreeNode tree) {
        super(component, true);
        this.myRootNode = tree;
        this.myTree = this.createCheckboxTree();
        this.myPane = new JScrollPane((Component)((Object)this.myTree));
        this.setTitle("Detected Source Roots");
        this.init();
    }

    private CheckboxTree createCheckboxTree() {
        CheckboxTree tree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(true){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Icon icon;
                SimpleTextAttributes attributes;
                String text;
                CheckedTreeNode node = (CheckedTreeNode)value;
                VirtualFile file = (VirtualFile)node.getUserObject();
                boolean isValid = true;
                if (leaf) {
                    VirtualFile ancestor = (VirtualFile)((CheckedTreeNode)node.getParent()).getUserObject();
                    text = ancestor != null ? VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)ancestor, (char)File.separatorChar) : file.getPresentableUrl();
                    if (text == null) {
                        isValid = false;
                        text = file.getPresentableUrl();
                    }
                    attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    icon = Icons.DIRECTORY_CLOSED_ICON;
                } else {
                    String string = text = file == null ? "found files" : file.getPresentableUrl();
                    if (text == null) {
                        isValid = false;
                    }
                    attributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                    icon = expanded ? Icons.DIRECTORY_OPEN_ICON : Icons.DIRECTORY_CLOSED_ICON;
                }
                ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
                textRenderer.setIcon(icon);
                if (!isValid) {
                    textRenderer.append("[INVALID] ", SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
                if (text != null) {
                    textRenderer.append(text, attributes);
                }
            }
        }, this.myRootNode);
        tree.setRootVisible(false);
        TreeUtil.expandAll((JTree)((Object)tree));
        return tree;
    }

    private static CheckedTreeNode createTree(Map<VirtualFile, List<VirtualFile>> detectedRoots) {
        CheckedTreeNode root = new CheckedTreeNode(null);
        for (Map.Entry<VirtualFile, List<VirtualFile>> e : detectedRoots.entrySet()) {
            root.add((MutableTreeNode)DetectedSourceRootsDialog.createTreeNode(e.getKey(), e.getValue()));
        }
        return root;
    }

    private static CheckedTreeNode createTree(VirtualFile baseRoot, List<VirtualFile> detectedRoots) {
        CheckedTreeNode root = new CheckedTreeNode(null);
        root.add((MutableTreeNode)DetectedSourceRootsDialog.createTreeNode(baseRoot, detectedRoots));
        return root;
    }

    private static CheckedTreeNode createTreeNode(VirtualFile baseRoot, List<VirtualFile> detectedRoots) {
        CheckedTreeNode node = new CheckedTreeNode((Object)baseRoot);
        for (VirtualFile f : detectedRoots) {
            node.add((MutableTreeNode)new CheckedTreeNode((Object)f));
        }
        return node;
    }

    protected JComponent createTitlePane() {
        return new TitlePanel("Choose Source Roots", "<html><body>IntelliJ IDEA just scanned files and detected following source root(s).<br>Select items in the tree below or press Cancel to cancel operation.</body></html>");
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPane;
    }

    public List<VirtualFile> getChosenRoots() {
        ArrayList<VirtualFile> rc = new ArrayList<VirtualFile>();
        Enumeration be = this.myRootNode.children();
        while (be.hasMoreElements()) {
            CheckedTreeNode baseFileNode = (CheckedTreeNode)be.nextElement();
            Enumeration de = baseFileNode.children();
            while (de.hasMoreElements()) {
                CheckedTreeNode dirNode = (CheckedTreeNode)de.nextElement();
                if (!dirNode.isChecked()) continue;
                rc.add((VirtualFile)dirNode.getUserObject());
            }
        }
        return rc;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "DetectedSourceRootsDialog";
    }
}

