/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ItemElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeContentElement;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLibraryTreeStructure
extends AbstractTreeStructure {
    protected NodeDescriptor myRootElementDescriptor;
    protected final LibraryTableEditor myParentEditor;

    public AbstractLibraryTreeStructure(LibraryTableEditor parentElement) {
        this.myParentEditor = parentElement;
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    protected Object[] buildItems(LibraryTableTreeContentElement parent, Library library, OrderRootType orderRootType) {
        ArrayList<ItemElement> items = new ArrayList<ItemElement>();
        LibraryEditor libraryEditor = this.myParentEditor.getLibraryEditor(library);
        String[] urls = (String[])libraryEditor.getUrls(orderRootType).clone();
        Arrays.sort(urls, LibraryTableEditor.ourUrlComparator);
        for (String url : urls) {
            items.add(new ItemElement(parent, library, url, orderRootType, libraryEditor.isJarDirectory(url), libraryEditor.isValid(url, orderRootType)));
        }
        return items.toArray();
    }

    public Object getParentElement(Object element) {
        Object rootElement = this.getRootElement();
        if (element == rootElement) {
            return null;
        }
        if (element instanceof LibraryTableTreeContentElement) {
            return ((LibraryTableTreeContentElement)element).getParent();
        }
        return rootElement;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        NodeDescriptor nodeDescriptor;
        if (element == this.getRootElement()) {
            NodeDescriptor nodeDescriptor2 = this.myRootElementDescriptor;
            nodeDescriptor = nodeDescriptor2;
            if (nodeDescriptor2 != null) return nodeDescriptor;
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/libraryEditor/AbstractLibraryTreeStructure.createDescriptor must not return null");
        }
        if (element instanceof LibraryTableTreeContentElement) {
            NodeDescriptor nodeDescriptor3 = ((LibraryTableTreeContentElement)element).createDescriptor(parentDescriptor, this.myParentEditor);
            nodeDescriptor = nodeDescriptor3;
            if (nodeDescriptor3 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/libraryEditor/AbstractLibraryTreeStructure.createDescriptor must not return null");
            return nodeDescriptor;
        }
        nodeDescriptor = null;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/libraryEditor/AbstractLibraryTreeStructure.createDescriptor must not return null");
    }
}

