/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.DelegatedSourceItemPresentation;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.packaging.impl.ui.ModuleElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.SourceItemPresentation;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModuleOutputSourceItem
extends PackagingSourceItem {
    private final Module myModule;

    public ModuleOutputSourceItem(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleOutputSourceItem.<init> must not be null");
        }
        this.myModule = module;
    }

    public boolean equals(Object obj) {
        return obj instanceof ModuleOutputSourceItem && this.myModule.equals(((ModuleOutputSourceItem)((Object)obj)).myModule);
    }

    public int hashCode() {
        return this.myModule.hashCode();
    }

    public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleOutputSourceItem.createPresentation must not be null");
        }
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)context.getProject()).create(this.myModule);
        return new DelegatedSourceItemPresentation(new ModuleElementPresentation(modulePointer, context)){

            @Override
            public int getWeight() {
                return 30;
            }
        };
    }

    @NotNull
    public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleOutputSourceItem.createElements must not be null");
        }
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)context.getProject()).create(this.myModule);
        List<ModuleOutputPackagingElement> list = Collections.singletonList(new ModuleOutputPackagingElement(context.getProject(), modulePointer));
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleOutputSourceItem.createElements must not return null");
        }
        return list;
    }

    @NotNull
    public PackagingElementOutputKind getKindOfProducedElements() {
        PackagingElementOutputKind packagingElementOutputKind = PackagingElementOutputKind.DIRECTORIES_WITH_CLASSES;
        if (packagingElementOutputKind == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleOutputSourceItem.getKindOfProducedElements must not return null");
        }
        return packagingElementOutputKind;
    }
}

