/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactConfigurable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorSettings;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContextImpl;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactAdapter;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.LibraryElementType;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ArtifactsStructureConfigurable.UI", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public class ArtifactsStructureConfigurable
extends BaseStructureConfigurable {
    private ArtifactsStructureConfigurableContextImpl myPackagingEditorContext;
    private ArtifactEditorSettings myDefaultSettings;

    public ArtifactsStructureConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable.<init> must not be null");
        }
        super(project);
        this.myDefaultSettings = new ArtifactEditorSettings();
        MasterDetailsStateService.getInstance((Project)project).register("ArtifactsStructureConfigurable.UI", (MasterDetailsComponent)this);
    }

    public void init(StructureConfigurableContext context, ModuleStructureConfigurable moduleStructureConfigurable, ProjectLibrariesConfigurable projectLibrariesConfig, GlobalLibrariesConfigurable globalLibrariesConfig) {
        super.init(context);
        this.myPackagingEditorContext = new ArtifactsStructureConfigurableContextImpl(this.myContext, this.myProject, this.myDefaultSettings, new ArtifactAdapter(){

            public void artifactAdded(@NotNull Artifact artifact) {
                if (artifact == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$1.artifactAdded must not be null");
                }
                MasterDetailsComponent.MyNode node = ArtifactsStructureConfigurable.this.addArtifactNode(artifact);
                ArtifactsStructureConfigurable.this.selectNodeInTree((DefaultMutableTreeNode)node);
                ArtifactsStructureConfigurable.this.myContext.getDaemonAnalyzer().queueUpdate(ArtifactsStructureConfigurable.this.myPackagingEditorContext.getOrCreateArtifactElement(artifact));
            }
        });
        context.getModulesConfigurator().addAllModuleChangeListener(new ModuleEditor.ChangeListener(){

            @Override
            public void moduleStateChanged(ModifiableRootModel moduleRootModel) {
                for (ProjectStructureElement projectStructureElement : ArtifactsStructureConfigurable.this.getProjectStructureElements()) {
                    ArtifactsStructureConfigurable.this.myContext.getDaemonAnalyzer().queueUpdate(projectStructureElement, true, false);
                }
            }
        });
        MasterDetailsComponent.ItemsChangeListener listener = new MasterDetailsComponent.ItemsChangeListener(){

            public void itemChanged(@Nullable Object deletedItem) {
                if (deletedItem instanceof Library || deletedItem instanceof Module) {
                    ArtifactsStructureConfigurable.this.onElementDeleted();
                }
            }

            public void itemsExternallyChanged() {
            }
        };
        moduleStructureConfigurable.addItemsChangeListener(listener);
        projectLibrariesConfig.addItemsChangeListener(listener);
        globalLibrariesConfig.addItemsChangeListener(listener);
        context.addLibraryEditorListener(new LibraryEditorListener(){

            @Override
            public void libraryRenamed(@NotNull Library library, String oldName, String newName) {
                Artifact[] artifacts;
                if (library == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$4.libraryRenamed must not be null");
                }
                for (Artifact artifact : artifacts = ArtifactsStructureConfigurable.this.myPackagingEditorContext.getArtifactModel().getArtifacts()) {
                    ArtifactsStructureConfigurable.this.updateLibraryElements(artifact, library, oldName, newName);
                }
            }
        });
    }

    private void updateLibraryElements(final Artifact artifact, final Library library, final String oldName, final String newName) {
        if (ArtifactUtil.processPackagingElements(this.myPackagingEditorContext.getRootElement(artifact), LibraryElementType.LIBRARY_ELEMENT_TYPE, new PackagingElementProcessor<LibraryPackagingElement>(){

            @Override
            public boolean process(@NotNull LibraryPackagingElement element, @NotNull PackagingElementPath path) {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$5.process must not be null");
                }
                if (path == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$5.process must not be null");
                }
                return !ArtifactsStructureConfigurable.isResolvedToLibrary(element, library, oldName);
            }
        }, this.myPackagingEditorContext, false, artifact.getArtifactType())) {
            return;
        }
        this.myPackagingEditorContext.editLayout(artifact, new Runnable(){

            @Override
            public void run() {
                ModifiableArtifact modifiableArtifact = ArtifactsStructureConfigurable.this.myPackagingEditorContext.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(artifact);
                ArtifactUtil.processPackagingElements((Artifact)modifiableArtifact, LibraryElementType.LIBRARY_ELEMENT_TYPE, new PackagingElementProcessor<LibraryPackagingElement>(){

                    @Override
                    public boolean process(@NotNull LibraryPackagingElement element, @NotNull PackagingElementPath path) {
                        if (element == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$6$1.process must not be null");
                        }
                        if (path == null) {
                            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$6$1.process must not be null");
                        }
                        if (ArtifactsStructureConfigurable.isResolvedToLibrary(element, library, oldName)) {
                            element.setLibraryName(newName);
                        }
                        return true;
                    }
                }, (PackagingElementResolvingContext)ArtifactsStructureConfigurable.this.myPackagingEditorContext, false);
            }
        });
        ArtifactEditorImpl artifactEditor = this.myPackagingEditorContext.getArtifactEditor(artifact);
        if (artifactEditor != null) {
            artifactEditor.rebuildTries();
        }
    }

    private static boolean isResolvedToLibrary(LibraryPackagingElement element, Library library, String name) {
        if (!element.getLibraryName().equals(name)) {
            return false;
        }
        LibraryTable table = library.getTable();
        if (table != null) {
            return table.getTableLevel().equals(element.getLevel());
        }
        return element.getLevel().equals("module");
    }

    private void onElementDeleted() {
        for (ArtifactEditorImpl artifactEditorImpl : this.myPackagingEditorContext.getArtifactEditors()) {
            artifactEditorImpl.getSourceItemsTree().rebuildTree();
            artifactEditorImpl.queueValidation();
        }
    }

    @Nls
    public String getDisplayName() {
        return ProjectBundle.message((String)"display.name.artifacts", (Object[])new Object[0]);
    }

    @Override
    protected void loadTree() {
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(false);
        for (Artifact artifact : this.myPackagingEditorContext.getArtifactModel().getArtifacts()) {
            this.addArtifactNode(artifact);
        }
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<ArtifactProjectStructureElement> elements = new ArrayList<ArtifactProjectStructureElement>();
        for (Artifact artifact : this.myPackagingEditorContext.getArtifactModel().getArtifacts()) {
            elements.add(this.myPackagingEditorContext.getOrCreateArtifactElement(artifact));
        }
        ArrayList<ArtifactProjectStructureElement> arrayList = elements;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable.getProjectStructureElements must not return null");
        }
        return arrayList;
    }

    private MasterDetailsComponent.MyNode addArtifactNode(Artifact artifact) {
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)new ArtifactConfigurable(artifact, this.myPackagingEditorContext, this.TREE_UPDATER));
        this.addNode(node, this.myRoot);
        return node;
    }

    protected PersistentStateComponent<?> getAdditionalSettings() {
        return this.myDefaultSettings;
    }

    @Override
    public void reset() {
        this.myPackagingEditorContext.resetModifiableModel();
        super.reset();
    }

    public boolean isModified() {
        ModifiableArtifactModel modifiableModel = this.myPackagingEditorContext.getActualModifiableModel();
        if (modifiableModel != null && modifiableModel.isModified()) {
            return true;
        }
        return this.myPackagingEditorContext.getManifestFilesInfo().isManifestFilesModified() || super.isModified();
    }

    public ArtifactsStructureConfigurableContext getArtifactsStructureContext() {
        return this.myPackagingEditorContext;
    }

    public ModifiableArtifactModel getModifiableArtifactModel() {
        return this.myPackagingEditorContext.getOrCreateModifiableArtifactModel();
    }

    @Override
    protected BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        return new BaseStructureConfigurable.AbstractAddGroup(ProjectBundle.message((String)"add.new.header.text", (Object[])new Object[0])){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                ArtifactType[] types = ArtifactType.getAllTypes();
                AnAction[] actions = new AnAction[types.length];
                for (int i = 0; i < types.length; ++i) {
                    actions[i] = ArtifactsStructureConfigurable.this.createAddArtifactAction(types[i]);
                }
                if (actions == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$7.getChildren must not return null");
                }
                return actions;
            }
        };
    }

    private AnAction createAddArtifactAction(final @NotNull ArtifactType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable.createAddArtifactAction must not be null");
        }
        List templates = type.getNewArtifactTemplates((PackagingElementResolvingContext)this.myPackagingEditorContext);
        ArtifactTemplate emptyTemplate = new ArtifactTemplate(){

            public String getPresentableName() {
                return "Empty";
            }

            public ArtifactTemplate.NewArtifactConfiguration createArtifact() {
                String name = "unnamed";
                return new ArtifactTemplate.NewArtifactConfiguration(type.createRootElement("unnamed"), "unnamed", type);
            }
        };
        if (templates.isEmpty()) {
            return new AddArtifactAction(type, emptyTemplate, type.getPresentableName(), type.getIcon());
        }
        DefaultActionGroup group = new DefaultActionGroup(type.getPresentableName(), true);
        group.getTemplatePresentation().setIcon(type.getIcon());
        group.add((AnAction)new AddArtifactAction(type, emptyTemplate, emptyTemplate.getPresentableName(), null));
        group.addSeparator();
        for (ArtifactTemplate template : templates) {
            group.add((AnAction)new AddArtifactAction(type, template, template.getPresentableName(), null));
        }
        return group;
    }

    private void addArtifact(@NotNull ArtifactType type, @NotNull ArtifactTemplate artifactTemplate) {
        String baseName;
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable.addArtifact must not be null");
        }
        if (artifactTemplate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable.addArtifact must not be null");
        }
        ArtifactTemplate.NewArtifactConfiguration configuration = artifactTemplate.createArtifact();
        if (configuration == null) {
            return;
        }
        String name = baseName = configuration.getArtifactName();
        int i = 2;
        while (this.myPackagingEditorContext.getArtifactModel().findArtifact(name) != null) {
            name = baseName + i;
            ++i;
        }
        ArtifactType actualType = configuration.getArtifactType();
        if (actualType == null) {
            actualType = type;
        }
        ModifiableArtifact artifact = this.myPackagingEditorContext.getOrCreateModifiableArtifactModel().addArtifact(name, actualType, configuration.getRootElement());
        this.selectNodeInTree((DefaultMutableTreeNode)ArtifactsStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)artifact));
    }

    public void apply() throws ConfigurationException {
        this.myPackagingEditorContext.saveEditorSettings();
        super.apply();
        this.myPackagingEditorContext.getManifestFilesInfo().saveManifestFiles();
        final ModifiableArtifactModel modifiableModel = this.myPackagingEditorContext.getActualModifiableModel();
        if (modifiableModel != null) {
            new WriteAction(){

                protected void run(Result result) {
                    modifiableModel.commit();
                }
            }.execute();
            this.myPackagingEditorContext.resetModifiableModel();
        }
        this.reset();
    }

    @Override
    public void disposeUIResources() {
        this.myPackagingEditorContext.saveEditorSettings();
        super.disposeUIResources();
        this.myPackagingEditorContext.disposeUIResources();
    }

    public String getHelpTopic() {
        String topic = super.getHelpTopic();
        return topic != null ? topic : "reference.settingsdialog.project.structure.artifacts";
    }

    @Override
    protected void removeArtifact(Artifact artifact) {
        this.myPackagingEditorContext.getOrCreateModifiableArtifactModel().removeArtifact(artifact);
        this.myContext.getDaemonAnalyzer().removeElement(this.myPackagingEditorContext.getOrCreateArtifactElement(artifact));
    }

    protected void processRemovedItems() {
    }

    protected boolean wasObjectStored(Object editableObject) {
        return false;
    }

    public String getId() {
        return "project.artifacts";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public void dispose() {
    }

    public Icon getIcon() {
        return null;
    }

    private class AddArtifactAction
    extends DumbAwareAction {
        private final ArtifactType myType;
        private final ArtifactTemplate myArtifactTemplate;

        public AddArtifactAction(@NotNull ArtifactType type, @NotNull ArtifactTemplate artifactTemplate, String actionText, Icon icon) {
            if (type == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$AddArtifactAction.<init> must not be null");
            }
            if (artifactTemplate == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$AddArtifactAction.<init> must not be null");
            }
            if (actionText == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$AddArtifactAction.<init> must not be null");
            }
            super(actionText, null, icon);
            this.myType = type;
            this.myArtifactTemplate = artifactTemplate;
        }

        public void actionPerformed(AnActionEvent e) {
            ArtifactsStructureConfigurable.this.addArtifact(this.myType, this.myArtifactTemplate);
        }
    }
}

