/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.LanguageLevelCombo;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectJdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectJdksModel;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.InsertPathAction;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.Chunk;
import com.intellij.util.graph.Graph;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ProjectConfigurable
extends NamedConfigurable<Project>
implements DetailsComponent.Facade {
    private final Project myProject;
    private static final Icon PROJECT_ICON = IconLoader.getIcon((String)"/nodes/project.png");
    private boolean myStartModuleWizardOnShow;
    private LanguageLevelCombo myLanguageLevelCombo;
    private ProjectJdkConfigurable myProjectJdkConfigurable;
    private FieldPanel myProjectCompilerOutput;
    private MyJPanel myPanel;
    private final Alarm myUpdateWarningAlarm;
    private final JLabel myWarningLabel;
    private final ModulesConfigurator myModulesConfigurator;
    private JPanel myWholePanel;
    private boolean myFreeze;
    private DetailsComponent myDetailsComponent;

    public ProjectConfigurable(Project project, ModulesConfigurator configurator, ProjectJdksModel model) {
        this.$$$setupUI$$$();
        this.myUpdateWarningAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
        this.myWarningLabel = new JLabel("");
        this.myFreeze = false;
        this.myProject = project;
        this.myModulesConfigurator = configurator;
        this.init(model);
    }

    public DetailsComponent getDetailsComponent() {
        return this.myDetailsComponent;
    }

    public JComponent createOptionsPanel() {
        this.myDetailsComponent = new DetailsComponent();
        this.myDetailsComponent.setContent((JComponent)this.myPanel);
        this.myDetailsComponent.setText(new String[]{this.getBannerSlogan()});
        this.myProjectJdkConfigurable.createComponent();
        return this.myDetailsComponent.getComponent();
    }

    private void init(ProjectJdksModel model) {
        this.myPanel = new MyJPanel();
        this.myPanel.setPreferredSize(new Dimension(700, 500));
        this.myProjectJdkConfigurable = new ProjectJdkConfigurable(this.myProject, model);
        this.myPanel.add((Component)this.myProjectJdkConfigurable.createComponent(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 0, 0), 0, 0));
        this.myPanel.add((Component)this.myWholePanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, new Insets(4, 0, 0, 0), 0, 0));
        this.myPanel.add((Component)this.myWarningLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 1, new Insets(10, 6, 10, 0), 0, 0));
        this.myProjectCompilerOutput.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (ProjectConfigurable.this.myFreeze) {
                    return;
                }
                ProjectConfigurable.this.myModulesConfigurator.processModuleCompilerOutputChanged(ProjectConfigurable.this.getCompilerOutputUrl());
            }
        });
    }

    public void disposeUIResources() {
        this.myUpdateWarningAlarm.cancelAllRequests();
        if (this.myProjectJdkConfigurable != null) {
            this.myProjectJdkConfigurable.disposeUIResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.myFreeze = true;
        try {
            this.myProjectJdkConfigurable.reset();
            String compilerOutput = CompilerProjectExtension.getInstance((Project)this.myProject).getCompilerOutputUrl();
            if (compilerOutput != null) {
                this.myProjectCompilerOutput.setText(FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)compilerOutput)));
            }
            this.myLanguageLevelCombo.reset(this.myProject);
            this.updateCircularDependencyWarning();
        }
        finally {
            this.myFreeze = false;
        }
    }

    void updateCircularDependencyWarning() {
        this.myUpdateWarningAlarm.cancelAllRequests();
        this.myUpdateWarningAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        Graph graph = ModuleCompilerUtil.toChunkGraph(ProjectConfigurable.this.myModulesConfigurator.createGraphGenerator());
                        Collection chunks = graph.getNodes();
                        String cycles = "";
                        int count = 0;
                        for (Chunk chunk : chunks) {
                            Set modules = chunk.getNodes();
                            String cycle = "";
                            for (ModifiableRootModel model : modules) {
                                cycle = cycle + ", " + model.getModule().getName();
                            }
                            if (modules.size() <= 1) continue;
                            String br = "<br>&nbsp;&nbsp;&nbsp;&nbsp;";
                            cycles = cycles + "<br>&nbsp;&nbsp;&nbsp;&nbsp;" + ++count + ". " + cycle.substring(2);
                        }
                        String leftBrace = "<html>";
                        String rightBrace = "</html>";
                        final String warningMessage = "<html>" + (count > 0 ? ProjectBundle.message((String)"module.circular.dependency.warning", (Object[])new Object[]{cycles, count}) : "") + "</html>";
                        final int count1 = count;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProjectConfigurable.this.myWarningLabel.setIcon(count1 > 0 ? Messages.getWarningIcon() : null);
                                ProjectConfigurable.this.myWarningLabel.setText(warningMessage);
                                ProjectConfigurable.this.myWarningLabel.repaint();
                            }
                        });
                    }
                });
            }
        }, 300);
    }

    public void apply() throws ConfigurationException {
        final CompilerProjectExtension compilerProjectExtension = CompilerProjectExtension.getInstance((Project)this.myProject);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                String canonicalPath = ProjectConfigurable.this.myProjectCompilerOutput.getText();
                if (canonicalPath != null && canonicalPath.length() > 0) {
                    try {
                        canonicalPath = FileUtil.resolveShortWindowsName((String)canonicalPath);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    canonicalPath = FileUtil.toSystemIndependentName((String)canonicalPath);
                    compilerProjectExtension.setCompilerOutputUrl(VfsUtil.pathToUrl((String)canonicalPath));
                } else {
                    compilerProjectExtension.setCompilerOutputPointer(null);
                }
                LanguageLevel newLevel = (LanguageLevel)ProjectConfigurable.this.myLanguageLevelCombo.getSelectedItem();
                LanguageLevelProjectExtension.getInstance((Project)ProjectConfigurable.this.myProject).setLanguageLevel(newLevel);
                try {
                    ProjectConfigurable.this.myProjectJdkConfigurable.apply();
                }
                catch (ConfigurationException configurationException) {
                    // empty catch block
                }
            }
        });
    }

    public void setDisplayName(String name) {
    }

    public Project getEditableObject() {
        return this.myProject;
    }

    public String getBannerSlogan() {
        return ProjectBundle.message((String)"project.roots.project.banner.text", (Object[])new Object[]{this.myProject.getName()});
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"project.roots.project.display.name", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return PROJECT_ICON;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settingsdialog.project.structure.general";
    }

    public boolean isModified() {
        if (!LanguageLevelProjectExtension.getInstance((Project)this.myProject).getLanguageLevel().equals(this.myLanguageLevelCombo.getSelectedItem())) {
            return true;
        }
        CompilerProjectExtension compilerProjectExtension = CompilerProjectExtension.getInstance((Project)this.myProject);
        String compilerOutput = compilerProjectExtension.getCompilerOutputUrl();
        if (!Comparing.strEqual((String)FileUtil.toSystemIndependentName((String)VfsUtil.urlToPath((String)compilerOutput)), (String)FileUtil.toSystemIndependentName((String)this.myProjectCompilerOutput.getText()))) {
            return true;
        }
        return this.myProjectJdkConfigurable.isModified();
    }

    private void createUIComponents() {
        this.myLanguageLevelCombo = new LanguageLevelCombo();
        JTextField textField = new JTextField();
        FileChooserDescriptor outputPathsChooserDescriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        InsertPathAction.addTo((JTextComponent)textField, (FileChooserDescriptor)outputPathsChooserDescriptor);
        outputPathsChooserDescriptor.setHideIgnored(false);
        BrowseFilesListener listener = new BrowseFilesListener(textField, "", ProjectBundle.message((String)"project.compiler.output", (Object[])new Object[0]), outputPathsChooserDescriptor);
        this.myProjectCompilerOutput = new FieldPanel(textField, null, null, (ActionListener)listener, EmptyRunnable.getInstance());
    }

    public void setStartModuleWizardOnShow(boolean show) {
        this.myStartModuleWizardOnShow = show;
    }

    public String getCompilerOutputUrl() {
        return VfsUtil.pathToUrl((String)this.myProjectCompilerOutput.getText().trim());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(14, 4, 4, 4), -1, 10, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.language.level"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        LanguageLevelCombo languageLevelCombo = this.myLanguageLevelCombo;
        jPanel2.add((Component)((Object)languageLevelCombo), new GridConstraints(0, 0, 1, 1, 8, 0, 7, 3, new Dimension(-1, 26), null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.compiler.output"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 6, 0, null, null, null));
        FieldPanel fieldPanel = this.myProjectCompilerOutput;
        jPanel3.add((Component)fieldPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, new Dimension(215, -1), null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyJPanel
    extends JPanel {
        public MyJPanel() {
            super(new GridBagLayout());
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (ProjectConfigurable.this.myStartModuleWizardOnShow) {
                final Window parentWindow = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
                parentWindow.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowActivated(WindowEvent e) {
                        parentWindow.removeWindowListener(this);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProjectConfigurable.this.myModulesConfigurator.addModule(parentWindow);
                            }
                        });
                    }
                });
            }
        }
    }
}

