/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.roots.IconActionComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public abstract class JavaContentRootPanel
extends ContentRootPanel {
    private static final Icon ADD_PREFIX_ICON = IconLoader.getIcon((String)"/modules/setPackagePrefix.png");
    private static final Icon ADD_PREFIX_ROLLOVER_ICON = IconLoader.getIcon((String)"/modules/setPackagePrefixRollover.png");

    public JavaContentRootPanel(ContentRootPanel.ActionCallback callback) {
        super(callback, true, true);
    }

    @Override
    @Nullable
    protected JComponent createAdditionalComponent(ContentFolder folder) {
        if (folder instanceof SourceFolder) {
            return this.createAddPrefixComponent((SourceFolder)folder);
        }
        return null;
    }

    private JComponent createAddPrefixComponent(final SourceFolder folder) {
        IconActionComponent iconComponent = new IconActionComponent(ADD_PREFIX_ICON, ADD_PREFIX_ROLLOVER_ICON, ProjectBundle.message((String)"module.paths.package.prefix.tooltip", (Object[])new Object[0]), new Runnable(){

            @Override
            public void run() {
                String message = ProjectBundle.message((String)"module.paths.package.prefix.prompt", (Object[])new Object[]{ContentRootPanel.toRelativeDisplayPath(folder.getUrl(), JavaContentRootPanel.this.getContentEntry().getUrl() + ":")});
                String prefix = Messages.showInputDialog((Component)JavaContentRootPanel.this, (String)message, (String)ProjectBundle.message((String)"module.paths.package.prefix.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)folder.getPackagePrefix(), null);
                if (prefix != null) {
                    JavaContentRootPanel.this.myCallback.setPackagePrefix(folder, prefix);
                }
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.add((Component)iconComponent, "Center");
        panel.add(Box.createHorizontalStrut(3), "East");
        return panel;
    }
}

