/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.roots.FilePathClipper;
import com.intellij.ui.roots.IconActionComponent;
import com.intellij.ui.roots.ResizingWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Stroke;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nullable;

public abstract class ContentRootPanel
extends JPanel {
    protected static final Color SOURCES_COLOR = new Color(676001);
    protected static final Color TESTS_COLOR = new Color(35886);
    protected static final Color EXCLUDED_COLOR = new Color(10038784);
    private static final Color SELECTED_HEADER_COLOR = new Color(14611199);
    private static final Color HEADER_COLOR = new Color(0xF5F5F5);
    private static final Color SELECTED_CONTENT_COLOR = new Color(0xF0F9FF);
    private static final Color CONTENT_COLOR = Color.WHITE;
    private static final Color UNSELECTED_TEXT_COLOR = new Color(0x333333);
    private static final Icon DELETE_ROOT_ICON = IconLoader.getIcon((String)"/modules/deleteContentRoot.png");
    private static final Icon DELETE_ROOT_ROLLOVER_ICON = IconLoader.getIcon((String)"/modules/deleteContentRootRollover.png");
    private static final Icon DELETE_FOLDER_ICON = IconLoader.getIcon((String)"/modules/deleteContentFolder.png");
    private static final Icon DELETE_FOLDER_ROLLOVER_ICON = IconLoader.getIcon((String)"/modules/deleteContentFolderRollover.png");
    protected final ActionCallback myCallback;
    private JComponent myHeader;
    private JComponent myBottom;
    private final Map<JComponent, Color> myComponentToForegroundMap = new HashMap<JComponent, Color>();
    private final boolean myCanMarkSources;
    private final boolean myCanMarkTestSources;

    public ContentRootPanel(ActionCallback callback, boolean canMarkSources, boolean canMarkTestSources) {
        super(new GridBagLayout());
        this.myCallback = callback;
        this.myCanMarkSources = canMarkSources;
        this.myCanMarkTestSources = canMarkTestSources;
    }

    @Nullable
    protected abstract ContentEntry getContentEntry();

    public void initUI() {
        this.myHeader = this.createHeader();
        this.add((Component)this.myHeader, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 8, 0), 0, 0));
        this.addFolderGroupComponents();
        this.myBottom = new JPanel(new BorderLayout());
        this.myBottom.add(Box.createVerticalStrut(3), "North");
        this.add((Component)this.myBottom, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setSelected(false);
    }

    protected void addFolderGroupComponents() {
        ExcludeFolder[] excludeFolders;
        SourceFolder[] sourceFolders;
        ArrayList<SourceFolder> sources = new ArrayList<SourceFolder>();
        ArrayList<SourceFolder> testSources = new ArrayList<SourceFolder>();
        ArrayList<ExcludeFolder> excluded = new ArrayList<ExcludeFolder>();
        for (SourceFolder folder : sourceFolders = this.getContentEntry().getSourceFolders()) {
            VirtualFile folderFile;
            if (folder.isSynthetic() || (folderFile = folder.getFile()) != null && (this.isExcluded(folderFile) || this.isUnderExcludedDirectory(folderFile))) continue;
            if (folder.isTestSource()) {
                testSources.add(folder);
                continue;
            }
            sources.add(folder);
        }
        for (ExcludeFolder excludeFolder : excludeFolders = this.getContentEntry().getExcludeFolders()) {
            if (excludeFolder.isSynthetic()) continue;
            excluded.add(excludeFolder);
        }
        if (sources.size() > 0 && this.myCanMarkSources) {
            JComponent sourcesComponent = this.createFolderGroupComponent(ProjectBundle.message((String)"module.paths.sources.group", (Object[])new Object[0]), sources.toArray(new ContentFolder[sources.size()]), SOURCES_COLOR);
            this.add((Component)sourcesComponent, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 10, 0), 0, 0));
        }
        if (testSources.size() > 0 && this.myCanMarkTestSources) {
            JComponent testSourcesComponent = this.createFolderGroupComponent(ProjectBundle.message((String)"module.paths.test.sources.group", (Object[])new Object[0]), testSources.toArray(new ContentFolder[testSources.size()]), TESTS_COLOR);
            this.add((Component)testSourcesComponent, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 10, 0), 0, 0));
        }
        if (excluded.size() > 0) {
            JComponent excludedComponent = this.createFolderGroupComponent(ProjectBundle.message((String)"module.paths.excluded.group", (Object[])new Object[0]), excluded.toArray(new ContentFolder[excluded.size()]), EXCLUDED_COLOR);
            this.add((Component)excludedComponent, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 10, 0), 0, 0));
        }
    }

    private JComponent createHeader() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel headerLabel = new JLabel(ContentRootPanel.toDisplayPath(this.getContentEntry().getUrl()));
        headerLabel.setFont(headerLabel.getFont().deriveFont(1));
        headerLabel.setOpaque(false);
        if (this.getContentEntry().getFile() == null) {
            headerLabel.setForeground(Color.RED);
        }
        IconActionComponent deleteIconComponent = new IconActionComponent(DELETE_ROOT_ICON, DELETE_ROOT_ROLLOVER_ICON, ProjectBundle.message((String)"module.paths.remove.content.tooltip", (Object[])new Object[0]), new Runnable(){

            @Override
            public void run() {
                ContentRootPanel.this.myCallback.deleteContentEntry();
            }
        });
        ResizingWrapper wrapper = new ResizingWrapper((JComponent)headerLabel);
        panel.add((Component)wrapper, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 2, 0, 0), 0, 0));
        panel.add((Component)deleteIconComponent, new GridBagConstraints(1, -1, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
        FilePathClipper.install((JLabel)headerLabel, (JComponent)wrapper);
        return panel;
    }

    protected JComponent createFolderGroupComponent(String title, ContentFolder[] folders, Color foregroundColor) {
        JPanel panel = new JPanel((LayoutManager)new GridLayoutManager(folders.length, 3, new Insets(1, 17, 0, 2), 0, 1));
        panel.setOpaque(false);
        for (int idx = 0; idx < folders.length; ++idx) {
            ContentFolder folder = folders[idx];
            int verticalPolicy = idx == folders.length - 1 ? 2 : 0;
            panel.add((Component)this.createFolderComponent(folder, foregroundColor), new GridConstraints(idx, 0, 1, 1, 9, 1, 3, verticalPolicy, null, null, null));
            int column = 1;
            int colspan = 2;
            JComponent additionalComponent = this.createAdditionalComponent(folder);
            if (additionalComponent != null) {
                panel.add((Component)additionalComponent, new GridConstraints(idx, column++, 1, 1, 0, 0, 0, verticalPolicy, null, null, null));
                colspan = 1;
            }
            panel.add((Component)this.createFolderDeleteComponent(folder), new GridConstraints(idx, column, 1, colspan, 4, 0, 0, verticalPolicy, null, null, null));
        }
        JLabel titleLabel = new JLabel(title);
        Font labelFont = UIUtil.getLabelFont();
        titleLabel.setFont(labelFont.deriveFont(1).deriveFont((float)labelFont.getSize() - 0.5f));
        titleLabel.setOpaque(false);
        titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.registerTextComponent(titleLabel, foregroundColor);
        JPanel groupPanel = new JPanel(new BorderLayout());
        groupPanel.setOpaque(false);
        groupPanel.add((Component)titleLabel, "North");
        groupPanel.add((Component)panel, "Center");
        return groupPanel;
    }

    @Nullable
    protected JComponent createAdditionalComponent(ContentFolder folder) {
        return null;
    }

    private void registerTextComponent(JComponent component, Color foreground) {
        component.setForeground(foreground);
        this.myComponentToForegroundMap.put(component, foreground);
    }

    private JComponent createFolderComponent(final ContentFolder folder, Color foreground) {
        String packagePrefix;
        VirtualFile folderFile = folder.getFile();
        VirtualFile contentEntryFile = this.getContentEntry().getFile();
        String string = packagePrefix = folder instanceof SourceFolder ? ((SourceFolder)folder).getPackagePrefix() : "";
        if (folderFile != null && contentEntryFile != null) {
            String path;
            String string2 = path = folderFile.equals(contentEntryFile) ? "." : VfsUtil.getRelativePath((VirtualFile)folderFile, (VirtualFile)contentEntryFile, (char)File.separatorChar);
            if (packagePrefix.length() > 0) {
                path = path + " (" + packagePrefix + ")";
            }
            HoverHyperlinkLabel hyperlinkLabel = new HoverHyperlinkLabel(path, foreground);
            hyperlinkLabel.setMinimumSize(new Dimension(0, 0));
            hyperlinkLabel.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    ContentRootPanel.this.myCallback.navigateFolder(ContentRootPanel.this.getContentEntry(), folder);
                }
            });
            this.registerTextComponent(hyperlinkLabel, foreground);
            return new UnderlinedPathLabel(hyperlinkLabel);
        }
        String path = ContentRootPanel.toRelativeDisplayPath(folder.getUrl(), this.getContentEntry().getUrl());
        if (packagePrefix.length() > 0) {
            path = path + " (" + packagePrefix + ")";
        }
        JLabel pathLabel = new JLabel(path);
        pathLabel.setOpaque(false);
        pathLabel.setForeground(Color.RED);
        return new UnderlinedPathLabel(pathLabel);
    }

    private JComponent createFolderDeleteComponent(final ContentFolder folder) {
        String tooltipText = folder.getFile() != null && this.getContentEntry().getFile() != null ? (folder instanceof SourceFolder ? (((SourceFolder)folder).isTestSource() ? ProjectBundle.message((String)"module.paths.unmark.tests.tooltip", (Object[])new Object[0]) : ProjectBundle.message((String)"module.paths.unmark.source.tooltip", (Object[])new Object[0])) : (folder instanceof ExcludeFolder ? ProjectBundle.message((String)"module.paths.include.excluded.tooltip", (Object[])new Object[0]) : null)) : ProjectBundle.message((String)"module.paths.remove.tooltip", (Object[])new Object[0]);
        return new IconActionComponent(DELETE_FOLDER_ICON, DELETE_FOLDER_ROLLOVER_ICON, tooltipText, new Runnable(){

            @Override
            public void run() {
                ContentRootPanel.this.myCallback.deleteContentFolder(ContentRootPanel.this.getContentEntry(), folder);
            }
        });
    }

    public boolean isExcluded(VirtualFile file) {
        return this.getExcludeFolder(file) != null;
    }

    public boolean isUnderExcludedDirectory(VirtualFile file) {
        ExcludeFolder[] excludeFolders;
        ContentEntry contentEntry = this.getContentEntry();
        if (contentEntry == null) {
            return false;
        }
        for (ExcludeFolder excludeFolder : excludeFolders = contentEntry.getExcludeFolders()) {
            VirtualFile excludedDir = excludeFolder.getFile();
            if (excludedDir == null || !VfsUtil.isAncestor((VirtualFile)excludedDir, (VirtualFile)file, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ExcludeFolder getExcludeFolder(VirtualFile file) {
        ExcludeFolder[] excludeFolders;
        ContentEntry contentEntry = this.getContentEntry();
        if (contentEntry == null) {
            return null;
        }
        for (ExcludeFolder excludeFolder : excludeFolders = contentEntry.getExcludeFolders()) {
            VirtualFile f = excludeFolder.getFile();
            if (f == null || !f.equals(file)) continue;
            return excludeFolder;
        }
        return null;
    }

    protected static String toRelativeDisplayPath(String url, String ancestorUrl) {
        if (!StringUtil.endsWithChar((CharSequence)ancestorUrl, (char)'/')) {
            ancestorUrl = ancestorUrl + "/";
        }
        if (url.startsWith(ancestorUrl)) {
            return url.substring(ancestorUrl.length()).replace('/', File.separatorChar);
        }
        return ContentRootPanel.toDisplayPath(url);
    }

    private static String toDisplayPath(String url) {
        return VirtualFileManager.extractPath((String)url).replace('/', File.separatorChar);
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.myHeader.setBackground(SELECTED_HEADER_COLOR);
            this.setBackground(SELECTED_CONTENT_COLOR);
            this.myBottom.setBackground(SELECTED_HEADER_COLOR);
            for (JComponent component : this.myComponentToForegroundMap.keySet()) {
                component.setForeground(this.myComponentToForegroundMap.get(component));
            }
        } else {
            this.myHeader.setBackground(HEADER_COLOR);
            this.setBackground(CONTENT_COLOR);
            this.myBottom.setBackground(HEADER_COLOR);
            for (JComponent component : this.myComponentToForegroundMap.keySet()) {
                component.setForeground(UNSELECTED_TEXT_COLOR);
            }
        }
    }

    private static class UnderlinedPathLabel
    extends ResizingWrapper {
        private static final float[] DASH = new float[]{0.0f, 2.0f, 0.0f, 2.0f};
        private static final Color DASH_LINE_COLOR = new Color(0xC9C9C9);

        public UnderlinedPathLabel(JLabel wrappedComponent) {
            super((JComponent)wrappedComponent);
            FilePathClipper.install((JLabel)wrappedComponent, (JComponent)((Object)this));
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int startX = this.myWrappedComponent.getWidth();
            int endX = this.getWidth();
            if (endX > startX) {
                FontMetrics fontMetrics = this.myWrappedComponent.getFontMetrics(this.myWrappedComponent.getFont());
                int y = fontMetrics.getMaxAscent();
                Color savedColor = g.getColor();
                g.setColor(DASH_LINE_COLOR);
                this.drawDottedLine((Graphics2D)g, startX, y, endX, y);
                g.setColor(savedColor);
            }
        }

        private void drawDottedLine(Graphics2D g, int x1, int y1, int x2, int y2) {
            if (SystemInfo.isMac) {
                UIUtil.drawLine((Graphics)g, (int)x1, (int)y1, (int)x2, (int)y2);
            } else {
                Stroke saved = g.getStroke();
                g.setStroke(new BasicStroke(1.0f, 1, 1, 0.0f, DASH, y1 % 2));
                UIUtil.drawLine((Graphics)g, (int)x1, (int)y1, (int)x2, (int)y2);
                g.setStroke(saved);
            }
        }
    }

    public static interface ActionCallback {
        public void deleteContentEntry();

        public void deleteContentFolder(ContentEntry var1, ContentFolder var2);

        public void navigateFolder(ContentEntry var1, ContentFolder var2);

        public void setPackagePrefix(SourceFolder var1, String var2);
    }
}

