/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.ApplicationLibraryTable;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.util.SmartList;
import com.intellij.util.containers.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LibraryTablesRegistrarImpl
extends LibraryTablesRegistrar
implements Disposable {
    private static final Map<String, LibraryTable> myLibraryTables = new HashMap();

    @NotNull
    public LibraryTable getLibraryTable() {
        ApplicationLibraryTable applicationLibraryTable = ApplicationLibraryTable.getApplicationTable();
        if (applicationLibraryTable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl.getLibraryTable must not return null");
        }
        return applicationLibraryTable;
    }

    @NotNull
    public LibraryTable getLibraryTable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl.getLibraryTable must not be null");
        }
        LibraryTable libraryTable = ProjectLibraryTable.getInstance(project);
        if (libraryTable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl.getLibraryTable must not return null");
        }
        return libraryTable;
    }

    public LibraryTable getLibraryTableByLevel(String level, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl.getLibraryTableByLevel must not be null");
        }
        if ("project".equals(level)) {
            return this.getLibraryTable(project);
        }
        if ("application".equals(level)) {
            return this.getLibraryTable();
        }
        return myLibraryTables.get(level);
    }

    public void registerLibraryTable(@NotNull LibraryTable libraryTable) {
        if (libraryTable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl.registerLibraryTable must not be null");
        }
        String tableLevel = libraryTable.getTableLevel();
        LibraryTable oldTable = myLibraryTables.put(tableLevel, libraryTable);
        if (oldTable != null) {
            throw new IllegalArgumentException("Library table '" + tableLevel + "' already registered.");
        }
    }

    @NotNull
    public LibraryTable registerLibraryTable(final String customLevel) {
        LibraryTableBase table = new LibraryTableBase(){

            public String getTableLevel() {
                return customLevel;
            }

            public LibraryTablePresentation getPresentation() {
                return new LibraryTablePresentation(){

                    public String getDisplayName(boolean plural) {
                        return customLevel;
                    }

                    public String getDescription() {
                        throw new UnsupportedOperationException("Method getDescription is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
                    }

                    public String getLibraryTableEditorTitle() {
                        throw new UnsupportedOperationException("Method getLibraryTableEditorTitle is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
                    }
                };
            }

            public boolean isEditable() {
                return false;
            }
        };
        this.registerLibraryTable(table);
        LibraryTableBase libraryTableBase = table;
        if (libraryTableBase == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl.registerLibraryTable must not return null");
        }
        return libraryTableBase;
    }

    public List<LibraryTable> getCustomLibraryTables() {
        return new SmartList(myLibraryTables.values());
    }

    public void dispose() {
        myLibraryTables.clear();
    }
}

