/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.LibraryOrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ModuleJdkOrderEntryImpl
extends LibraryOrderEntryBaseImpl
implements WritableOrderEntry,
ClonableOrderEntry,
ModuleJdkOrderEntry,
ProjectJdkTable.Listener {
    @NonNls
    static final String ENTRY_TYPE = "jdk";
    @NonNls
    private static final String JDK_NAME_ATTR = "jdkName";
    @NonNls
    private static final String JDK_TYPE_ATTR = "jdkType";
    private Sdk myJdk;
    private String myJdkName;
    private String myJdkType;

    ModuleJdkOrderEntryImpl(@NotNull Sdk projectJdk, RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager) {
        if (projectJdk == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl.<init> must not be null");
        }
        super(rootModel, projectRootManager);
        this.init(projectJdk, null, null);
    }

    ModuleJdkOrderEntryImpl(Element element, RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        super(rootModel, projectRootManager);
        if (!element.getName().equals("orderEntry")) {
            throw new InvalidDataException();
        }
        Attribute jdkNameAttribute = element.getAttribute(JDK_NAME_ATTR);
        if (jdkNameAttribute == null) {
            throw new InvalidDataException();
        }
        String jdkName = jdkNameAttribute.getValue();
        String jdkType = element.getAttributeValue(JDK_TYPE_ATTR);
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        Sdk jdkByName = projectJdkTable.findJdk(jdkName, jdkType);
        if (jdkByName == null) {
            this.init(null, jdkName, jdkType);
        } else {
            this.init(jdkByName, null, null);
        }
    }

    private ModuleJdkOrderEntryImpl(ModuleJdkOrderEntryImpl that, RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager) {
        super(rootModel, projectRootManager);
        this.init(that.myJdk, that.getJdkName(), that.getJdkType());
    }

    public ModuleJdkOrderEntryImpl(String jdkName, String jdkType, RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager) {
        super(rootModel, projectRootManager);
        this.init(null, jdkName, jdkType);
    }

    private void init(Sdk jdk, String jdkName, String jdkType) {
        this.myJdk = jdk;
        this.setJdkName(jdkName);
        this.setJdkType(jdkType);
        this.addListener();
        this.init();
    }

    private String getJdkType() {
        if (this.myJdk != null) {
            return this.myJdk.getSdkType().getName();
        }
        return this.myJdkType;
    }

    private void addListener() {
        this.myProjectRootManagerImpl.addJdkTableListener(this);
    }

    @Override
    protected RootProvider getRootProvider() {
        return this.myJdk == null ? null : this.myJdk.getRootProvider();
    }

    public Sdk getJdk() {
        return this.getRootModel().getConfigurationAccessor().getSdk(this.myJdk, this.myJdkName);
    }

    public String getJdkName() {
        if (this.myJdkName != null) {
            return this.myJdkName;
        }
        Sdk jdk = this.getJdk();
        if (jdk != null) {
            return jdk.getName();
        }
        return null;
    }

    public boolean isSynthetic() {
        return true;
    }

    public String getPresentableName() {
        return "< " + (this.myJdk == null ? this.getJdkName() : this.myJdk.getName()) + " >";
    }

    public boolean isValid() {
        return !this.isDisposed() && this.getJdk() != null;
    }

    public <R> R accept(RootPolicy<R> policy, R initialValue) {
        return (R)policy.visitModuleJdkOrderEntry((ModuleJdkOrderEntry)this, initialValue);
    }

    public void jdkAdded(Sdk jdk) {
        if (this.myJdk == null && this.getJdkName().equals(jdk.getName())) {
            this.myJdk = jdk;
            this.setJdkName(null);
            this.setJdkType(null);
            this.updateFromRootProviderAndSubscribe();
        }
    }

    public void jdkNameChanged(Sdk jdk, String previousName) {
        if (this.myJdk == null && this.getJdkName().equals(jdk.getName())) {
            this.myJdk = jdk;
            this.setJdkName(null);
            this.setJdkType(null);
            this.updateFromRootProviderAndSubscribe();
        }
    }

    public void jdkRemoved(Sdk jdk) {
        if (jdk == this.myJdk) {
            this.setJdkName(this.myJdk.getName());
            this.setJdkType(this.myJdk.getSdkType().getName());
            this.myJdk = null;
            this.updateFromRootProviderAndSubscribe();
        }
    }

    @Override
    public void writeExternal(Element rootElement) throws WriteExternalException {
        String jdkType;
        Element element = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        String jdkName = this.getJdkName();
        if (jdkName != null) {
            element.setAttribute(JDK_NAME_ATTR, jdkName);
        }
        if ((jdkType = this.getJdkType()) != null) {
            element.setAttribute(JDK_TYPE_ATTR, jdkType);
        }
        rootElement.addContent(element);
    }

    @Override
    public OrderEntry cloneEntry(RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        return new ModuleJdkOrderEntryImpl(this, rootModel, ProjectRootManagerImpl.getInstanceImpl(this.getRootModel().getModule().getProject()));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myProjectRootManagerImpl.removeJdkTableListener(this);
    }

    private void setJdkName(String jdkName) {
        this.myJdkName = jdkName;
    }

    private void setJdkType(String jdkType) {
        this.myJdkType = jdkType;
    }
}

