/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.FileIndexImplUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModuleFileIndexImpl
implements ModuleFileIndex {
    private final Module myModule;
    private final FileTypeManager myFileTypeManager;
    private final DirectoryIndex myDirectoryIndex;
    private final ContentFilter myContentFilter;

    public ModuleFileIndexImpl(Module module, DirectoryIndex directoryIndex) {
        this.myModule = module;
        this.myDirectoryIndex = directoryIndex;
        this.myFileTypeManager = FileTypeManager.getInstance();
        this.myContentFilter = new ContentFilter();
    }

    public boolean iterateContent(@NotNull ContentIterator iterator) {
        VirtualFile[] contentRoots;
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ModuleFileIndexImpl.iterateContent must not be null");
        }
        for (VirtualFile contentRoot : contentRoots = ModuleRootManager.getInstance((Module)this.myModule).getContentRoots()) {
            boolean finished;
            DirectoryInfo parentInfo;
            VirtualFile parent = contentRoot.getParent();
            if (parent != null && (parentInfo = this.myDirectoryIndex.getInfoForDirectory(parent)) != null && this.myModule.equals(parentInfo.module) || (finished = FileIndexImplUtil.iterateRecursively((VirtualFile)contentRoot, (VirtualFileFilter)this.myContentFilter, (ContentIterator)iterator))) continue;
            return false;
        }
        return true;
    }

    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator iterator) {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ModuleFileIndexImpl.iterateContentUnderDirectory must not be null");
        }
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/impl/ModuleFileIndexImpl.iterateContentUnderDirectory must not be null");
        }
        return FileIndexImplUtil.iterateRecursively((VirtualFile)dir, (VirtualFileFilter)this.myContentFilter, (ContentIterator)iterator);
    }

    public boolean isContentJavaSourceFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ModuleFileIndexImpl.isContentJavaSourceFile must not be null");
        }
        return !file.isDirectory() && this.myFileTypeManager.getFileTypeByFile(file) == StdFileTypes.JAVA && !this.myFileTypeManager.isFileIgnored(file.getName()) && this.isInSourceContent(file);
    }

    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ModuleFileIndexImpl.isInContent must not be null");
        }
        if (fileOrDir.isDirectory()) {
            DirectoryInfo info = this.myDirectoryIndex.getInfoForDirectory(fileOrDir);
            return info != null && this.myModule.equals(info.module);
        }
        VirtualFile parent = fileOrDir.getParent();
        return parent != null && this.isInContent(parent);
    }

    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ModuleFileIndexImpl.isInSourceContent must not be null");
        }
        if (fileOrDir.isDirectory()) {
            DirectoryInfo info = this.myDirectoryIndex.getInfoForDirectory(fileOrDir);
            return info != null && info.isInModuleSource && this.myModule.equals(info.module);
        }
        VirtualFile parent = fileOrDir.getParent();
        return parent != null && this.isInSourceContent(parent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile fileOrDir) {
        SmartList smartList;
        VirtualFile dir;
        if (fileOrDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ModuleFileIndexImpl.getOrderEntriesForFile must not be null");
        }
        VirtualFile virtualFile = dir = fileOrDir.isDirectory() ? fileOrDir : fileOrDir.getParent();
        if (dir == null) {
            smartList = Collections.emptyList();
            if (smartList == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleFileIndexImpl.getOrderEntriesForFile must not return null");
            return smartList;
        }
        DirectoryInfo info = this.myDirectoryIndex.getInfoForDirectory(dir);
        if (info == null) {
            smartList = Collections.emptyList();
            if (smartList == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleFileIndexImpl.getOrderEntriesForFile must not return null");
            return smartList;
        }
        List<OrderEntry> orderEntries = info.getOrderEntries();
        if (orderEntries.isEmpty()) {
            smartList = Collections.emptyList();
            if (smartList == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleFileIndexImpl.getOrderEntriesForFile must not return null");
            return smartList;
        }
        SmartList answer = new SmartList();
        for (OrderEntry entry : orderEntries) {
            if (entry.getOwnerModule() != this.myModule) continue;
            answer.add((Object)entry);
        }
        smartList = answer;
        if (smartList != null) return smartList;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleFileIndexImpl.getOrderEntriesForFile must not return null");
    }

    public OrderEntry getOrderEntryForFile(@NotNull VirtualFile fileOrDir) {
        VirtualFile dir;
        if (fileOrDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ModuleFileIndexImpl.getOrderEntryForFile must not be null");
        }
        VirtualFile virtualFile = dir = fileOrDir.isDirectory() ? fileOrDir : fileOrDir.getParent();
        if (dir == null) {
            return null;
        }
        DirectoryInfo info = this.myDirectoryIndex.getInfoForDirectory(dir);
        if (info == null) {
            return null;
        }
        List<OrderEntry> orderEntries = info.getOrderEntries();
        for (int i = 0; i < orderEntries.size(); ++i) {
            OrderEntry orderEntry = orderEntries.get(i);
            if (orderEntry.getOwnerModule() != this.myModule) continue;
            return orderEntry;
        }
        return null;
    }

    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ModuleFileIndexImpl.isInTestSourceContent must not be null");
        }
        if (fileOrDir.isDirectory()) {
            DirectoryInfo info = this.myDirectoryIndex.getInfoForDirectory(fileOrDir);
            return info != null && info.isInModuleSource && info.isTestSource && this.myModule.equals(info.module);
        }
        VirtualFile parent = fileOrDir.getParent();
        return parent != null && this.isInTestSourceContent(parent);
    }

    private class ContentFilter
    implements VirtualFileFilter {
        private ContentFilter() {
        }

        public boolean accept(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ModuleFileIndexImpl$ContentFilter.accept must not be null");
            }
            if (file.isDirectory()) {
                DirectoryInfo info = ModuleFileIndexImpl.this.myDirectoryIndex.getInfoForDirectory(file);
                return info != null && ModuleFileIndexImpl.this.myModule.equals(info.module);
            }
            return !ModuleFileIndexImpl.this.myFileTypeManager.isFileIgnored(file.getName());
        }
    }
}

