/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.LibraryOrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LibraryOrderEntryImpl
extends LibraryOrderEntryBaseImpl
implements LibraryOrderEntry,
ClonableOrderEntry,
WritableOrderEntry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.LibraryOrderEntryImpl");
    private Library myLibrary;
    private String myLibraryName;
    private String myLibraryLevel;
    private boolean myExported;
    @NonNls
    static final String ENTRY_TYPE = "library";
    @NonNls
    private static final String NAME_ATTR = "name";
    @NonNls
    private static final String LEVEL_ATTR = "level";
    private final MyOrderEntryLibraryTableListener myLibraryListener;
    @NonNls
    private static final String EXPORTED_ATTR = "exported";

    LibraryOrderEntryImpl(Library library, RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager) {
        super(rootModel, projectRootManager);
        this.myLibraryListener = new MyOrderEntryLibraryTableListener();
        LOG.assertTrue(library.getTable() != null);
        this.myLibrary = library;
        this.addListeners();
        this.init();
    }

    LibraryOrderEntryImpl(Element element, RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        super(rootModel, projectRootManager);
        this.myLibraryListener = new MyOrderEntryLibraryTableListener();
        LOG.assertTrue(ENTRY_TYPE.equals(element.getAttributeValue("type")));
        this.myExported = element.getAttributeValue(EXPORTED_ATTR) != null;
        this.myScope = DependencyScope.readExternal((Element)element);
        String level = element.getAttributeValue(LEVEL_ATTR);
        String name = element.getAttributeValue(NAME_ATTR);
        if (name == null) {
            throw new InvalidDataException();
        }
        if (level == null) {
            throw new InvalidDataException();
        }
        this.searchForLibrary(name, level);
        this.addListeners();
        this.init();
    }

    private LibraryOrderEntryImpl(LibraryOrderEntryImpl that, RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager) {
        super(rootModel, projectRootManager);
        this.myLibraryListener = new MyOrderEntryLibraryTableListener();
        if (that.myLibrary == null) {
            this.myLibraryName = that.myLibraryName;
            this.myLibraryLevel = that.myLibraryLevel;
        } else {
            this.myLibrary = that.myLibrary;
        }
        this.myExported = that.myExported;
        this.myScope = that.myScope;
        this.addListeners();
        this.init();
    }

    public LibraryOrderEntryImpl(@NotNull String name, @NotNull String level, RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/LibraryOrderEntryImpl.<init> must not be null");
        }
        if (level == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/impl/LibraryOrderEntryImpl.<init> must not be null");
        }
        super(rootModel, projectRootManager);
        this.myLibraryListener = new MyOrderEntryLibraryTableListener();
        this.searchForLibrary(name, level);
        this.addListeners();
    }

    private void searchForLibrary(@NotNull String name, @NotNull String level) {
        Library library;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/LibraryOrderEntryImpl.searchForLibrary must not be null");
        }
        if (level == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/impl/LibraryOrderEntryImpl.searchForLibrary must not be null");
        }
        if (this.myLibrary != null) {
            return;
        }
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, this.getRootModel().getModule().getProject());
        Library library2 = library = libraryTable != null ? libraryTable.getLibraryByName(name) : null;
        if (library == null) {
            this.myLibraryName = name;
            this.myLibraryLevel = level;
            this.myLibrary = null;
        } else {
            this.myLibraryName = null;
            this.myLibraryLevel = null;
            this.myLibrary = library;
        }
    }

    public boolean isExported() {
        return this.myExported;
    }

    public void setExported(boolean exported) {
        this.myExported = exported;
    }

    @NotNull
    public DependencyScope getScope() {
        DependencyScope dependencyScope = this.myScope;
        if (dependencyScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/LibraryOrderEntryImpl.getScope must not return null");
        }
        return dependencyScope;
    }

    public void setScope(@NotNull DependencyScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/LibraryOrderEntryImpl.setScope must not be null");
        }
        this.myScope = scope;
    }

    @Nullable
    public Library getLibrary() {
        Library library = this.getRootModel().getConfigurationAccessor().getLibrary(this.myLibrary, this.myLibraryName, this.myLibraryLevel);
        if (library != null) {
            return library;
        }
        if (this.myLibrary != null) {
            this.myLibraryName = this.myLibrary.getName();
            this.myLibraryLevel = this.myLibrary.getTable().getTableLevel();
        }
        this.myLibrary = null;
        return null;
    }

    public boolean isModuleLevel() {
        return false;
    }

    public String getPresentableName() {
        return this.getLibraryName();
    }

    @Override
    @Nullable
    protected RootProvider getRootProvider() {
        return this.myLibrary == null ? null : this.myLibrary.getRootProvider();
    }

    public boolean isValid() {
        if (this.isDisposed()) {
            return false;
        }
        Library library = this.getLibrary();
        return library != null && !((LibraryEx)library).isDisposed();
    }

    public <R> R accept(RootPolicy<R> policy, R initialValue) {
        return (R)policy.visitLibraryOrderEntry((LibraryOrderEntry)this, initialValue);
    }

    @Override
    public OrderEntry cloneEntry(RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        ProjectRootManagerImpl rootManager = ProjectRootManagerImpl.getInstanceImpl(this.getRootModel().getModule().getProject());
        return new LibraryOrderEntryImpl(this, rootModel, rootManager);
    }

    @Override
    public void writeExternal(Element rootElement) throws WriteExternalException {
        Element element = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        String libraryLevel = this.getLibraryLevel();
        if (this.myExported) {
            element.setAttribute(EXPORTED_ATTR, "");
        }
        this.myScope.writeExternal(element);
        element.setAttribute(NAME_ATTR, this.getLibraryName());
        element.setAttribute(LEVEL_ATTR, libraryLevel);
        rootElement.addContent(element);
    }

    public String getLibraryLevel() {
        if (this.myLibrary != null) {
            LibraryTable table = this.myLibrary.getTable();
            return table.getTableLevel();
        }
        return this.myLibraryLevel;
    }

    public String getLibraryName() {
        return this.myLibrary == null ? this.myLibraryName : this.myLibrary.getName();
    }

    private void addListeners() {
        String libraryLevel = this.getLibraryLevel();
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(libraryLevel, this.getRootModel().getModule().getProject());
        if (libraryTable != null) {
            this.myProjectRootManagerImpl.addListenerForTable(this.myLibraryListener, libraryTable);
        }
    }

    public boolean isSynthetic() {
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(this.getLibraryLevel(), this.getRootModel().getModule().getProject());
        if (libraryTable != null) {
            this.myProjectRootManagerImpl.removeListenerForTable(this.myLibraryListener, libraryTable);
        }
    }

    private void afterLibraryAdded(Library newLibrary) {
        if (this.myLibrary == null && Comparing.equal((String)this.myLibraryName, (String)newLibrary.getName())) {
            this.myLibrary = newLibrary;
            this.myLibraryName = null;
            this.myLibraryLevel = null;
            this.updateFromRootProviderAndSubscribe();
        }
    }

    private void beforeLibraryRemoved(Library library) {
        if (library == this.myLibrary) {
            this.myLibraryName = this.myLibrary.getName();
            this.myLibraryLevel = this.myLibrary.getTable().getTableLevel();
            this.myLibrary = null;
            this.updateFromRootProviderAndSubscribe();
        }
    }

    private class MyOrderEntryLibraryTableListener
    implements LibraryTable.Listener {
        public void afterLibraryAdded(Library newLibrary) {
            LibraryOrderEntryImpl.this.afterLibraryAdded(newLibrary);
        }

        public void afterLibraryRenamed(Library library) {
            this.afterLibraryAdded(library);
        }

        public void beforeLibraryRemoved(Library library) {
            LibraryOrderEntryImpl.this.beforeLibraryRemoved(library);
        }

        public void afterLibraryRemoved(Library library) {
        }
    }
}

