/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.ex.ProjectRoot;
import com.intellij.openapi.projectRoots.impl.ProjectRootUtil;
import com.intellij.openapi.projectRoots.impl.SimpleProjectRoot;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

class CompositeProjectRoot
implements ProjectRoot {
    private final List<ProjectRoot> myRoots = new ArrayList<ProjectRoot>();

    CompositeProjectRoot() {
    }

    ProjectRoot[] getProjectRoots() {
        return this.myRoots.toArray(new ProjectRoot[this.myRoots.size()]);
    }

    @Override
    public String getPresentableString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public VirtualFile[] getVirtualFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (ProjectRoot root : this.myRoots) {
            result.addAll(Arrays.asList(root.getVirtualFiles()));
        }
        return VfsUtil.toVirtualFileArray(result);
    }

    @Override
    public String[] getUrls() {
        ArrayList<String> result = new ArrayList<String>();
        for (ProjectRoot root : this.myRoots) {
            result.addAll(Arrays.asList(root.getUrls()));
        }
        return ArrayUtil.toStringArray(result);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    void remove(ProjectRoot root) {
        this.myRoots.remove(root);
    }

    ProjectRoot add(VirtualFile virtualFile) {
        SimpleProjectRoot root = new SimpleProjectRoot(virtualFile);
        this.myRoots.add(root);
        return root;
    }

    void add(ProjectRoot root) {
        this.myRoots.add(root);
    }

    void remove(VirtualFile root) {
        Iterator<ProjectRoot> iterator = this.myRoots.iterator();
        while (iterator.hasNext()) {
            SimpleProjectRoot r;
            ProjectRoot projectRoot = iterator.next();
            if (!(projectRoot instanceof SimpleProjectRoot) || (r = (SimpleProjectRoot)projectRoot).getFile() == null || !r.getFile().equals(root)) continue;
            iterator.remove();
        }
    }

    void clear() {
        this.myRoots.clear();
    }

    public void readExternal(Element element) throws InvalidDataException {
        List children = element.getChildren();
        for (Object aChildren : children) {
            Element e = (Element)aChildren;
            this.myRoots.add(ProjectRootUtil.read(e));
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (ProjectRoot root : this.myRoots) {
            Element e = ProjectRootUtil.write(root);
            if (e == null) continue;
            element.addContent(e);
        }
    }

    @Override
    public void update() {
        for (ProjectRoot root : this.myRoots) {
            root.update();
        }
    }
}

