/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class CacheUpdateSession {
    private static final Logger LOG = Logger.getInstance((String)("#" + CacheUpdateSession.class.getName()));
    private static final Key<Boolean> FAILED_TO_INDEX = Key.create((String)(CacheUpdateSession.class.getSimpleName() + ".FAILED_TO_INDEX"));
    private final Collection<VirtualFile> myFilesToUpdate;
    private final int myJobsToDo;
    private final List<Pair<CacheUpdater, Collection<VirtualFile>>> myUpdatersWithFiles = new ArrayList<Pair<CacheUpdater, Collection<VirtualFile>>>();

    public CacheUpdateSession(Collection<CacheUpdater> updaters, ProgressIndicator indicator) {
        ArrayList<CacheUpdater> processedUpdaters = new ArrayList<CacheUpdater>();
        this.myFilesToUpdate = new LinkedHashSet<VirtualFile>();
        try {
            int jobsCount = 0;
            for (CacheUpdater each : updaters) {
                indicator.checkCanceled();
                try {
                    jobsCount += each.getNumberOfPendingUpdateJobs();
                    List<VirtualFile> updaterFiles = Arrays.asList(each.queryNeededFiles());
                    processedUpdaters.add(each);
                    this.myFilesToUpdate.addAll(updaterFiles);
                    this.myUpdatersWithFiles.add((Pair<CacheUpdater, Collection<VirtualFile>>)Pair.create((Object)each, (Object)new THashSet(updaterFiles)));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
            this.myJobsToDo = jobsCount;
        }
        catch (ProcessCanceledException e) {
            for (CacheUpdater each : processedUpdaters) {
                each.canceled();
            }
            throw e;
        }
    }

    public int getNumberOfPendingUpdateJobs() {
        return this.myJobsToDo;
    }

    public Collection<VirtualFile> getFilesToUpdate() {
        return this.myFilesToUpdate;
    }

    public void processFile(FileContent content) {
        VirtualFile file = content.getVirtualFile();
        boolean isValid = file.isValid();
        Iterator<Pair<CacheUpdater, Collection<VirtualFile>>> it = this.myUpdatersWithFiles.iterator();
        while (it.hasNext()) {
            Pair<CacheUpdater, Collection<VirtualFile>> eachPair = it.next();
            CacheUpdater eachUpdater = (CacheUpdater)eachPair.first;
            Collection eachFiles = (Collection)eachPair.second;
            if (!eachFiles.contains(file)) continue;
            try {
                if (isValid && !Boolean.TRUE.equals(file.getUserData(FAILED_TO_INDEX))) {
                    eachUpdater.processFile(content);
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error("Error while indexing " + file.getPresentableUrl() + "\n" + "To reindex this file IDEA has to be restarted", e);
                file.putUserData(FAILED_TO_INDEX, (Object)Boolean.TRUE);
            }
            eachFiles.remove(file);
            if (!eachFiles.isEmpty()) continue;
            try {
                eachUpdater.updatingDone();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            it.remove();
        }
    }

    public void updatingDone() {
        for (Pair<CacheUpdater, Collection<VirtualFile>> eachPair : this.myUpdatersWithFiles) {
            try {
                CacheUpdater eachUpdater = (CacheUpdater)eachPair.first;
                eachUpdater.updatingDone();
                if (((Collection)eachPair.second).isEmpty()) continue;
                LOG.error(CacheUpdater.class.getSimpleName() + " " + eachUpdater + " has not finished yet:\n" + eachPair.second);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void canceled() {
        for (Pair<CacheUpdater, Collection<VirtualFile>> eachPair : this.myUpdatersWithFiles) {
            ((CacheUpdater)eachPair.first).canceled();
        }
    }
}

