/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticPathReferenceProvider
extends PathReferenceProviderBase {
    private boolean myEndingSlashNotAllowed;
    private boolean myRelativePathsAllowed;
    private FileType[] mySuitableFileTypes;

    public StaticPathReferenceProvider(@Nullable FileType[] suitableFileTypes) {
        this.mySuitableFileTypes = suitableFileTypes;
    }

    @Override
    public boolean createReferences(@NotNull PsiElement psiElement, int offset, String text, @NotNull List<PsiReference> references, final boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/paths/StaticPathReferenceProvider.createReferences must not be null");
        }
        if (references == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/paths/StaticPathReferenceProvider.createReferences must not be null");
        }
        FileReferenceSet set = new FileReferenceSet(text, psiElement, offset, null, true, this.myEndingSlashNotAllowed, this.mySuitableFileTypes){

            @Override
            protected boolean isUrlEncoded() {
                return true;
            }

            @Override
            protected boolean isSoft() {
                return soft;
            }
        };
        if (!this.myRelativePathsAllowed) {
            set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, FileReferenceSet.ABSOLUTE_TOP_LEVEL);
        }
        Collections.addAll(references, set.getAllReferences());
        return true;
    }

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/paths/StaticPathReferenceProvider.getPathReference must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/paths/StaticPathReferenceProvider.getPathReference must not be null");
        }
        ArrayList<PsiReference> list = new ArrayList<PsiReference>(5);
        this.createReferences(element, list, true);
        if (list.isEmpty()) {
            return null;
        }
        final PsiElement target = list.get(list.size() - 1).resolve();
        if (target == null) {
            return null;
        }
        return new PathReference(path, (Function)PathReference.ResolveFunction.NULL_RESOLVE_FUNCTION){

            public PsiElement resolve() {
                return target;
            }
        };
    }

    public void setEndingSlashNotAllowed(boolean endingSlashNotAllowed) {
        this.myEndingSlashNotAllowed = endingSlashNotAllowed;
    }

    public void setRelativePathsAllowed(boolean relativePathsAllowed) {
        this.myRelativePathsAllowed = relativePathsAllowed;
    }
}

