/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class ModuleRuntimeClasspathScope
extends GlobalSearchScope {
    private final ProjectFileIndex myIndex;
    private final boolean myIncludeTests;
    private final LinkedHashSet<VirtualFile> myEntries = new LinkedHashSet();
    private final Module myModule;

    public ModuleRuntimeClasspathScope(Module module, boolean includeTests) {
        super(module.getProject());
        this.myModule = module;
        this.myIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        this.myIncludeTests = includeTests;
        this.buildEntries(module);
    }

    public int hashCode() {
        return this.myModule.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object.getClass() != ModuleRuntimeClasspathScope.class) {
            return false;
        }
        ModuleRuntimeClasspathScope that = (ModuleRuntimeClasspathScope)((Object)object);
        return that.myModule == this.myModule && that.myIncludeTests == this.myIncludeTests;
    }

    private void buildEntries(Module module) {
        final HashSet<Module> processedModules = new HashSet<Module>();
        processedModules.add(module);
        ModuleRootManager.getInstance((Module)module).processOrder((RootPolicy)new RootPolicy<LinkedHashSet<VirtualFile>>(){
            private boolean myJDKProcessed = false;

            public LinkedHashSet<VirtualFile> visitModuleSourceOrderEntry(ModuleSourceOrderEntry moduleSourceOrderEntry, LinkedHashSet<VirtualFile> value) {
                value.addAll(Arrays.asList(moduleSourceOrderEntry.getFiles(OrderRootType.SOURCES)));
                return value;
            }

            public LinkedHashSet<VirtualFile> visitLibraryOrderEntry(LibraryOrderEntry libraryOrderEntry, LinkedHashSet<VirtualFile> value) {
                value.addAll(Arrays.asList(libraryOrderEntry.getFiles(OrderRootType.CLASSES)));
                return value;
            }

            public LinkedHashSet<VirtualFile> visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, LinkedHashSet<VirtualFile> value) {
                Module depModule = moduleOrderEntry.getModule();
                if (depModule != null && !processedModules.contains(depModule)) {
                    processedModules.add(depModule);
                    ModuleRootManager.getInstance((Module)depModule).processOrder((RootPolicy)this, value);
                }
                return value;
            }

            public LinkedHashSet<VirtualFile> visitJdkOrderEntry(JdkOrderEntry jdkOrderEntry, LinkedHashSet<VirtualFile> value) {
                if (this.myJDKProcessed) {
                    return value;
                }
                this.myJDKProcessed = true;
                value.addAll(Arrays.asList(jdkOrderEntry.getFiles(OrderRootType.CLASSES)));
                return value;
            }
        }, this.myEntries);
    }

    public boolean contains(VirtualFile file) {
        if (!this.myIncludeTests && this.myIndex.isInTestSourceContent(file)) {
            return false;
        }
        return this.myEntries.contains(this.getFileRoot(file));
    }

    private VirtualFile getFileRoot(VirtualFile file) {
        if (this.myIndex.isLibraryClassFile(file)) {
            return this.myIndex.getClassRootForFile(file);
        }
        if (this.myIndex.isInContent(file)) {
            return this.myIndex.getSourceRootForFile(file);
        }
        return null;
    }

    public int compare(VirtualFile file1, VirtualFile file2) {
        VirtualFile r1 = this.getFileRoot(file1);
        VirtualFile r2 = this.getFileRoot(file2);
        for (VirtualFile root : this.myEntries) {
            if (r1 == root) {
                return 1;
            }
            if (r2 != root) continue;
            return -1;
        }
        return 0;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/scopes/ModuleRuntimeClasspathScope.isSearchInModuleContent must not be null");
        }
        return true;
    }

    public boolean isSearchInLibraries() {
        return true;
    }

    public String getDisplayName() {
        return PsiBundle.message((String)"runtime.scope.display.name", (Object[])new Object[]{this.myModule.getName()});
    }
}

