/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.BundledKeymapProvider;
import com.intellij.openapi.keymap.impl.DefaultKeymapImpl;
import com.intellij.openapi.keymap.impl.MacOSDefaultKeymap;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class DefaultKeymap {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.keymap.impl.DefaultKeymap");
    @NonNls
    private static final String KEY_MAP = "keymap";
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    private final ArrayList<Keymap> myKeymaps = new ArrayList();

    public static DefaultKeymap getInstance() {
        return (DefaultKeymap)ServiceManager.getService(DefaultKeymap.class);
    }

    public DefaultKeymap() {
        for (BundledKeymapProvider provider : (BundledKeymapProvider[])Extensions.getExtensions(BundledKeymapProvider.EP_NAME)) {
            List<String> fileNames = provider.getKeymapFileNames();
            for (String fileName : fileNames) {
                try {
                    Document document = JDOMUtil.loadResourceDocument((URL)new URL("file:///idea/" + fileName));
                    this.loadKeymapsFromElement(document.getRootElement());
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    private void loadKeymapsFromElement(Element element) throws InvalidDataException {
        for (Element child : element.getChildren()) {
            if (!KEY_MAP.equals(child.getName())) continue;
            String keymapName = child.getAttributeValue(NAME_ATTRIBUTE);
            DefaultKeymapImpl keymap = keymapName.startsWith("Mac OS X") ? new MacOSDefaultKeymap() : new DefaultKeymapImpl();
            keymap.readExternal(child, this.myKeymaps.toArray(new Keymap[this.myKeymaps.size()]));
            keymap.setName(keymapName);
            this.myKeymaps.add(keymap);
        }
    }

    public Keymap[] getKeymaps() {
        return this.myKeymaps.toArray(new Keymap[this.myKeymaps.size()]);
    }
}

