/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.ex;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.NativeFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.fileTypes.impl.FileTypeRenderer;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileTypeChooser
extends DialogWrapper {
    private final DefaultListModel myModel;
    private JList myList;
    private JLabel myTitleLabel;
    private JTextField myPattern;
    private JPanel myPanel;
    private JRadioButton myOpenInIdea;
    private JRadioButton myOpenAsNative;
    private final String myFileName;

    private FileTypeChooser(String pattern, String fileName) {
        super(true);
        this.$$$setupUI$$$();
        this.myModel = new DefaultListModel();
        this.myFileName = fileName;
        this.myOpenInIdea.setText("Open matching files in " + ApplicationNamesInfo.getInstance().getProductName() + ":");
        FileType[] fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes();
        Arrays.sort(fileTypes, new Comparator<FileType>(){

            @Override
            public int compare(FileType fileType1, FileType fileType2) {
                if (fileType1 == null) {
                    return 1;
                }
                if (fileType2 == null) {
                    return -1;
                }
                return fileType1.getDescription().compareToIgnoreCase(fileType2.getDescription());
            }
        });
        for (FileType type : fileTypes) {
            if (type.isReadOnly() || type == FileTypes.UNKNOWN || type instanceof NativeFileType) continue;
            this.myModel.addElement(type);
        }
        this.myList.setModel(this.myModel);
        this.myPattern.setText(pattern);
        this.setTitle(FileTypesBundle.message("filetype.chooser.title", new Object[0]));
        this.init();
    }

    protected JComponent createCenterPanel() {
        this.myTitleLabel.setText(FileTypesBundle.message("filetype.chooser.prompt", this.myFileName));
        this.myList.setSelectionMode(0);
        this.myList.setCellRenderer(new FileTypeRenderer());
        this.myList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FileTypeChooser.this.doOKAction();
                }
            }
        });
        this.myList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FileTypeChooser.this.updateButtonsState();
            }
        });
        ListScrollingUtil.selectItem((JList)this.myList, (Object)FileTypes.PLAIN_TEXT);
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    private void updateButtonsState() {
        this.setOKActionEnabled(this.myList.getSelectedIndex() != -1 || this.myOpenAsNative.isSelected());
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.fileTypes.FileTypeChooser";
    }

    public FileType getSelectedType() {
        return this.myOpenAsNative.isSelected() ? NativeFileType.INSTANCE : (FileType)this.myList.getSelectedValue();
    }

    public static FileType getKnownFileTypeOrAssociate(VirtualFile file) {
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        FileType type = fileTypeManager.getFileTypeByFile(file);
        if (type == FileTypes.UNKNOWN) {
            type = FileTypeChooser.getKnownFileTypeOrAssociate(file.getName());
        }
        return type;
    }

    public static FileType getKnownFileTypeOrAssociate(String fileName) {
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        FileType type = fileTypeManager.getFileTypeByFileName(fileName);
        if (type == FileTypes.UNKNOWN) {
            type = FileTypeChooser.associateFileType(fileName);
        }
        return type;
    }

    public static FileType associateFileType(String fileName) {
        final FileTypeChooser chooser = new FileTypeChooser(FileTypeChooser.suggestPatternText(fileName), fileName);
        chooser.show();
        if (!chooser.isOK()) {
            return null;
        }
        final FileType type = chooser.getSelectedType();
        if (type == FileTypes.UNKNOWN) {
            return null;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileTypeManagerEx.getInstanceEx().associatePattern(type, chooser.myPattern.getText());
            }
        });
        return type;
    }

    private static String suggestPatternText(String fileName) {
        String pattern = FileUtil.getExtension((String)fileName);
        String finalPattern = StringUtil.isEmpty((String)pattern) ? fileName : "*." + pattern;
        return finalPattern;
    }

    protected String getHelpId() {
        return "reference.dialogs.register.association";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JList jList;
        JTextField jTextField;
        JLabel jLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTitleLabel = jLabel = new JLabel();
        jLabel.setText("Cannot associate _template_");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/FileTypesBundle").getString("filetype.chooser.file.pattern"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPattern = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(3, 0, 1, 2, 0, 3, 7, 7, null, new Dimension(150, 200), null, 2));
        this.myList = jList = new JList();
        jScrollPane.setViewportView(jList);
        this.myOpenInIdea = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("Open matching files in PRODUCTNAME as type:");
        jPanel.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myOpenAsNative = jRadioButton = new JRadioButton();
        jRadioButton.setText("Open matching files in associated application");
        jPanel.add((Component)jRadioButton, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel2.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

