/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.DocumentsEditor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorProvider
implements FileEditorProvider,
DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.text.TextEditorProvider");
    private static final Key<TextEditor> TEXT_EDITOR_KEY = Key.create((String)"textEditor");
    @NonNls
    private static final String TYPE_ID = "text-editor";
    @NonNls
    private static final String LINE_ATTR = "line";
    @NonNls
    private static final String COLUMN_ATTR = "column";
    @NonNls
    private static final String SELECTION_START_ATTR = "selection-start";
    @NonNls
    private static final String SELECTION_END_ATTR = "selection-end";
    @NonNls
    private static final String VERTICAL_SCROLL_PROPORTION_ATTR = "vertical-scroll-proportion";

    public static TextEditorProvider getInstance() {
        return (TextEditorProvider)ApplicationManager.getApplication().getComponent(TextEditorProvider.class);
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.accept must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.accept must not be null");
        }
        if (file.isDirectory() || !file.isValid()) {
            return false;
        }
        FileType ft = file.getFileType();
        if (ft.isBinary()) {
            return BinaryFileTypeDecompilers.INSTANCE.forFileType(ft) != null;
        }
        return true;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.createEditor must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.createEditor must not be null");
        }
        LOG.assertTrue(this.accept(project, file));
        TextEditorImpl textEditorImpl = new TextEditorImpl(project, file, this);
        if (textEditorImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.createEditor must not return null");
        }
        return textEditorImpl;
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.disposeEditor must not be null");
        }
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project, @NotNull VirtualFile file) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.readState must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.readState must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.readState must not be null");
        }
        TextEditorState state = new TextEditorState();
        try {
            state.LINE = Integer.parseInt(element.getAttributeValue(LINE_ATTR));
            state.COLUMN = Integer.parseInt(element.getAttributeValue(COLUMN_ATTR));
            state.SELECTION_START = Integer.parseInt(element.getAttributeValue(SELECTION_START_ATTR));
            state.SELECTION_END = Integer.parseInt(element.getAttributeValue(SELECTION_END_ATTR));
            state.VERTICAL_SCROLL_PROPORTION = Float.parseFloat(element.getAttributeValue(VERTICAL_SCROLL_PROPORTION_ATTR));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        TextEditorState textEditorState = state;
        if (textEditorState == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.readState must not return null");
        }
        return textEditorState;
    }

    public void writeState(@NotNull FileEditorState _state, @NotNull Project project, @NotNull Element element) {
        if (_state == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.writeState must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.writeState must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.writeState must not be null");
        }
        TextEditorState state = (TextEditorState)_state;
        element.setAttribute(LINE_ATTR, Integer.toString(state.LINE));
        element.setAttribute(COLUMN_ATTR, Integer.toString(state.COLUMN));
        element.setAttribute(SELECTION_START_ATTR, Integer.toString(state.SELECTION_START));
        element.setAttribute(SELECTION_END_ATTR, Integer.toString(state.SELECTION_END));
        element.setAttribute(VERTICAL_SCROLL_PROPORTION_ATTR, Float.toString(state.VERTICAL_SCROLL_PROPORTION));
    }

    @NotNull
    public String getEditorTypeId() {
        if (TYPE_ID == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.getEditorTypeId must not return null");
        }
        return TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.NONE;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.getPolicy must not return null");
        }
        return fileEditorPolicy;
    }

    @NotNull
    public TextEditor getTextEditor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.getTextEditor must not be null");
        }
        TextEditor textEditor = (TextEditor)editor.getUserData(TEXT_EDITOR_KEY);
        if (textEditor == null) {
            textEditor = this.createWrapperForEditor(editor);
            TextEditorProvider.putTextEditor(editor, textEditor);
        }
        TextEditor textEditor2 = textEditor;
        if (textEditor2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.getTextEditor must not return null");
        }
        return textEditor2;
    }

    protected EditorWrapper createWrapperForEditor(Editor editor) {
        return new EditorWrapper(editor);
    }

    @Nullable
    public static Document[] getDocuments(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.getDocuments must not be null");
        }
        if (editor instanceof DocumentsEditor) {
            DocumentsEditor documentsEditor = (DocumentsEditor)editor;
            Document[] documents = documentsEditor.getDocuments();
            if (documents.length > 0) {
                return documents;
            }
            return null;
        }
        if (editor instanceof TextEditor) {
            Document document = ((TextEditor)editor).getEditor().getDocument();
            return new Document[]{document};
        }
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        for (int i = projects.length - 1; i >= 0; --i) {
            Document document;
            VirtualFile file = FileEditorManagerEx.getInstanceEx(projects[i]).getFile(editor);
            if (file == null || (document = FileDocumentManager.getInstance().getDocument(file)) == null) continue;
            return new Document[]{document};
        }
        return null;
    }

    static void putTextEditor(Editor editor, TextEditor textEditor) {
        editor.putUserData(TEXT_EDITOR_KEY, (Object)textEditor);
    }

    protected TextEditorState getStateImpl(Project project, Editor editor, @NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider.getStateImpl must not be null");
        }
        TextEditorState state = new TextEditorState();
        state.LINE = editor.getCaretModel().getLogicalPosition().line;
        state.COLUMN = editor.getCaretModel().getLogicalPosition().column;
        state.SELECTION_START = editor.getSelectionModel().getSelectionStart();
        state.SELECTION_END = editor.getSelectionModel().getSelectionEnd();
        state.VERTICAL_SCROLL_PROPORTION = level == FileEditorStateLevel.UNDO ? -1.0f : EditorUtil.calcVerticalScrollProportion(editor);
        return state;
    }

    protected void setStateImpl(Project project, Editor editor, TextEditorState state) {
        LogicalPosition pos = new LogicalPosition(state.LINE, state.COLUMN);
        editor.getCaretModel().moveToLogicalPosition(pos);
        editor.getSelectionModel().removeSelection();
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        if (state.VERTICAL_SCROLL_PROPORTION != -1.0f) {
            EditorUtil.setVerticalScrollProportion(editor, state.VERTICAL_SCROLL_PROPORTION);
        }
        Document document = editor.getDocument();
        if (state.SELECTION_START == state.SELECTION_END) {
            editor.getSelectionModel().removeSelection();
        } else {
            int startOffset = Math.min(state.SELECTION_START, document.getTextLength());
            int endOffset = Math.min(state.SELECTION_END, document.getTextLength());
            editor.getSelectionModel().setSelection(startOffset, endOffset);
        }
        ((EditorEx)editor).stopOptimizedScrolling();
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    protected class EditorWrapper
    extends UserDataHolderBase
    implements TextEditor {
        private final Editor myEditor;

        public EditorWrapper(Editor editor) {
            this.myEditor = editor;
        }

        @NotNull
        public Editor getEditor() {
            Editor editor = this.myEditor;
            if (editor == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper.getEditor must not return null");
            }
            return editor;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myEditor.getComponent();
            if (jComponent == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper.getComponent must not return null");
            }
            return jComponent;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myEditor.getContentComponent();
        }

        @NotNull
        public String getName() {
            if ("Text" == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper.getName must not return null");
            }
            return "Text";
        }

        public StructureViewBuilder getStructureViewBuilder() {
            VirtualFile file = FileDocumentManager.getInstance().getFile(this.myEditor.getDocument());
            if (file == null) {
                return null;
            }
            Project project = this.myEditor.getProject();
            LOG.assertTrue(project != null);
            return StructureViewBuilder.PROVIDER.getStructureViewBuilder(file.getFileType(), file, project);
        }

        @NotNull
        public FileEditorState getState(@NotNull FileEditorStateLevel level) {
            if (level == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper.getState must not be null");
            }
            TextEditorState textEditorState = TextEditorProvider.this.getStateImpl(null, this.myEditor, level);
            if (textEditorState == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper.getState must not return null");
            }
            return textEditorState;
        }

        public void setState(@NotNull FileEditorState state) {
            if (state == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper.setState must not be null");
            }
            TextEditorProvider.this.setStateImpl(null, this.myEditor, (TextEditorState)state);
        }

        public boolean isModified() {
            return false;
        }

        public boolean isValid() {
            return true;
        }

        public void dispose() {
        }

        public void selectNotify() {
        }

        public void deselectNotify() {
        }

        public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper.addPropertyChangeListener must not be null");
            }
        }

        public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper.removePropertyChangeListener must not be null");
            }
        }

        public BackgroundEditorHighlighter getBackgroundHighlighter() {
            return null;
        }

        public FileEditorLocation getCurrentLocation() {
            return null;
        }

        public boolean canNavigateTo(@NotNull Navigatable navigatable) {
            if (navigatable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper.canNavigateTo must not be null");
            }
            return false;
        }

        public void navigateTo(@NotNull Navigatable navigatable) {
            if (navigatable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper.navigateTo must not be null");
            }
        }
    }
}

