/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.WaverGraphicsDecorator;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class PsiAwareFileEditorManagerImpl
extends FileEditorManagerImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.text.PsiAwareFileEditorManagerImpl");
    private final PsiManager myPsiManager;
    private final WolfTheProblemSolver myProblemSolver;
    private final MyPsiTreeChangeListener myPsiTreeChangeListener;
    private final WolfTheProblemSolver.ProblemListener myProblemListener;

    public PsiAwareFileEditorManagerImpl(Project project, PsiManager psiManager, WolfTheProblemSolver problemSolver) {
        super(project);
        this.myPsiManager = psiManager;
        this.myProblemSolver = problemSolver;
        this.myPsiTreeChangeListener = new MyPsiTreeChangeListener();
        this.myProblemListener = new MyProblemListener();
        this.registerExtraEditorDataProvider(new TextEditorPsiDataProvider(), null);
    }

    @Override
    public void projectOpened() {
        super.projectOpened();
        this.myPsiManager.addPsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeListener);
        this.myProblemSolver.addProblemListener(this.myProblemListener);
    }

    @Override
    public Color getFileColor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl.getFileColor must not be null");
        }
        Color color = super.getFileColor(file);
        if (this.myProblemSolver.isProblemFile(file)) {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), WaverGraphicsDecorator.WAVE_ALPHA_KEY);
        }
        return color;
    }

    @Override
    public boolean isProblem(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl.isProblem must not be null");
        }
        return this.myProblemSolver.isProblemFile(file);
    }

    @Override
    public String getFileTooltipText(VirtualFile file) {
        StringBuilder tooltipText = new StringBuilder();
        Module module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)this.getProject());
        if (module != null) {
            tooltipText.append("[");
            tooltipText.append(module.getName());
            tooltipText.append("] ");
        }
        tooltipText.append(file.getPresentableUrl());
        return tooltipText.toString();
    }

    @Override
    protected Editor getOpenedEditor(Editor editor, boolean focusEditor) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        Document document = editor.getDocument();
        PsiFile psiFile = documentManager.getPsiFile(document);
        if (!focusEditor || documentManager.isUncommited(document)) {
            return editor;
        }
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, psiFile);
    }

    private class MyProblemListener
    extends WolfTheProblemSolver.ProblemListener {
        private MyProblemListener() {
        }

        public void problemsAppeared(VirtualFile file) {
            this.updateFile(file);
        }

        public void problemsDisappeared(VirtualFile file) {
            this.updateFile(file);
        }

        public void problemsChanged(VirtualFile file) {
            this.updateFile(file);
        }

        private void updateFile(VirtualFile file) {
            PsiAwareFileEditorManagerImpl.this.queueUpdateFile(file);
        }
    }

    private final class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeListener() {
        }

        public void propertyChanged(PsiTreeChangeEvent e) {
            if ("roots".equals(e.getPropertyName())) {
                ApplicationManager.getApplication().assertIsDispatchThread();
                VirtualFile[] openFiles = PsiAwareFileEditorManagerImpl.this.getOpenFiles();
                for (int i = openFiles.length - 1; i >= 0; --i) {
                    VirtualFile file = openFiles[i];
                    LOG.assertTrue(file != null);
                    PsiAwareFileEditorManagerImpl.this.updateFileIcon(file);
                }
            }
        }

        public void childAdded(PsiTreeChangeEvent event) {
            this.doChange(event);
        }

        public void childRemoved(PsiTreeChangeEvent event) {
            this.doChange(event);
        }

        public void childReplaced(PsiTreeChangeEvent event) {
            this.doChange(event);
        }

        public void childMoved(PsiTreeChangeEvent event) {
            this.doChange(event);
        }

        public void childrenChanged(PsiTreeChangeEvent event) {
            this.doChange(event);
        }

        private void doChange(PsiTreeChangeEvent event) {
            PsiFile psiFile = event.getFile();
            VirtualFile currentFile = PsiAwareFileEditorManagerImpl.this.getCurrentFile();
            if (currentFile != null && psiFile != null && psiFile.getVirtualFile() == currentFile) {
                PsiAwareFileEditorManagerImpl.this.updateFileIcon(currentFile);
            }
        }
    }
}

