/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class HistoryEntry {
    @NonNls
    public static final String TAG = "entry";
    public final VirtualFile myFile;
    public FileEditorProvider mySelectedProvider;
    private final HashMap<FileEditorProvider, FileEditorState> myProvider2State;
    @NonNls
    public static final String FILE_ATTR = "file";
    @NonNls
    public static final String PROVIDER_ATTR = "provider";
    @NonNls
    public static final String EDITOR_TYPE_ID_ATTR = "editor-type-id";
    @NonNls
    public static final String SELECTED_ATTR_VALUE = "selected";
    @NonNls
    public static final String STATE_ELEMENT = "state";

    public HistoryEntry(@NotNull VirtualFile file, @NotNull FileEditorProvider[] providers, @NotNull FileEditorState[] states, @NotNull FileEditorProvider selectedProvider) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/HistoryEntry.<init> must not be null");
        }
        if (providers == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/HistoryEntry.<init> must not be null");
        }
        if (states == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/HistoryEntry.<init> must not be null");
        }
        if (selectedProvider == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/HistoryEntry.<init> must not be null");
        }
        this.myFile = file;
        this.myProvider2State = new HashMap();
        this.mySelectedProvider = selectedProvider;
        for (int i = 0; i < providers.length; ++i) {
            this.putState(providers[i], states[i]);
        }
    }

    public HistoryEntry(Project project, Element e) throws InvalidDataException {
        if (!e.getName().equals(TAG)) {
            throw new IllegalArgumentException("unexpected tag: " + e);
        }
        String url = e.getAttributeValue(FILE_ATTR);
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file == null) {
            throw new InvalidDataException();
        }
        this.myFile = file;
        this.myProvider2State = new HashMap();
        List providers = e.getChildren(PROVIDER_ATTR);
        for (Object provider1 : providers) {
            Element stateElement;
            Element _e = (Element)provider1;
            String typeId = _e.getAttributeValue(EDITOR_TYPE_ID_ATTR);
            FileEditorProvider provider = FileEditorProviderManager.getInstance().getProvider(typeId);
            if (provider == null) continue;
            if (Boolean.valueOf(_e.getAttributeValue(SELECTED_ATTR_VALUE)).booleanValue()) {
                this.mySelectedProvider = provider;
            }
            if ((stateElement = _e.getChild(STATE_ELEMENT)) == null) {
                throw new InvalidDataException();
            }
            FileEditorState state = provider.readState(stateElement, project, file);
            this.putState(provider, state);
        }
    }

    public FileEditorState getState(@NotNull FileEditorProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/HistoryEntry.getState must not be null");
        }
        return (FileEditorState)this.myProvider2State.get((Object)provider);
    }

    public void putState(@NotNull FileEditorProvider provider, @NotNull FileEditorState state) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/HistoryEntry.putState must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/HistoryEntry.putState must not be null");
        }
        this.myProvider2State.put((Object)provider, (Object)state);
    }

    public Element writeExternal(Element element, Project project) {
        Element e = new Element(TAG);
        element.addContent(e);
        e.setAttribute(FILE_ATTR, this.myFile.getUrl());
        for (Map.Entry entry : this.myProvider2State.entrySet()) {
            FileEditorProvider provider = (FileEditorProvider)entry.getKey();
            Element providerElement = new Element(PROVIDER_ATTR);
            if (provider.equals(this.mySelectedProvider)) {
                providerElement.setAttribute(SELECTED_ATTR_VALUE, Boolean.TRUE.toString());
            }
            providerElement.setAttribute(EDITOR_TYPE_ID_ATTR, provider.getEditorTypeId());
            Element stateElement = new Element(STATE_ELEMENT);
            providerElement.addContent(stateElement);
            provider.writeState((FileEditorState)entry.getValue(), project, stateElement);
            e.addContent(providerElement);
        }
        return e;
    }
}

