/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.fileChooser.ex.FileSaverDialogImpl;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;

public class FileChooserFactoryImpl
extends FileChooserFactory {
    public FileChooserDialog createFileChooser(FileChooserDescriptor descriptor, Project project) {
        return new FileChooserDialogImpl(descriptor, project);
    }

    public FileChooserDialog createFileChooser(FileChooserDescriptor descriptor, Component parent) {
        return new FileChooserDialogImpl(descriptor, parent);
    }

    public FileTextField createFileTextField(FileChooserDescriptor descriptor, boolean showHidden, Disposable parent) {
        return new FileTextFieldImpl.Vfs(descriptor, showHidden, new JTextField(), FileChooserFactoryImpl.getMacroMap(), parent);
    }

    public FileTextField createFileTextField(FileChooserDescriptor descriptor, Disposable parent) {
        return this.createFileTextField(descriptor, true, parent);
    }

    public void installFileCompletion(JTextField field, FileChooserDescriptor descriptor, boolean showHidden, Disposable parent) {
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        FileTextFieldImpl.Vfs vfsField = new FileTextFieldImpl.Vfs(descriptor, showHidden, field, FileChooserFactoryImpl.getMacroMap(), parent);
    }

    public static Map<String, String> getMacroMap() {
        PathMacros macros = PathMacros.getInstance();
        Set allNames = macros.getAllMacroNames();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String eachMacroName : allNames) {
            map.put("$" + eachMacroName + "$", macros.getValue(eachMacroName));
        }
        return map;
    }

    public FileSaverDialog createSaveFileDialog(FileSaverDescriptor descriptor, Project project) {
        return new FileSaverDialogImpl(descriptor, project);
    }
}

