/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class FileDrop {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileChooser.ex.FileDrop");

    public FileDrop(JComponent c, final Target target) {
        DropTargetListener listener = new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                dtde.acceptDrop(dtde.getDropAction());
                ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
                try {
                    List list = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    for (int i = 0; i < list.size(); ++i) {
                        Object each = list.get(i);
                        if (!(each instanceof File)) continue;
                        File eachFile = (File)each;
                        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(eachFile);
                        if (vFile == null || !vFile.exists() || !target.getDescriptor().isFileVisible(vFile, target.isHiddenShown())) continue;
                        files.add(vFile);
                    }
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
                if (files.size() > 0) {
                    target.dropFiles(files);
                }
            }
        };
        new DropTarget(c, 3, listener, true);
    }

    public static interface Target {
        public FileChooserDescriptor getDescriptor();

        public boolean isHiddenShown();

        public void dropFiles(List<VirtualFile> var1);
    }
}

