/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public class SettingsImpl
implements EditorSettings {
    @Nullable
    private final EditorEx myEditor;
    private Boolean myIsCamelWords;
    private int myAdditionalLinesCount = 5;
    private int myAdditionalColumnsCount = 3;
    private int myLineCursorWidth = 2;
    private boolean myLineMarkerAreaShown = true;
    private Integer myTabSize = null;
    private Integer myCachedTabSize;
    private Boolean myUseTabCharacter = null;
    private Boolean myIsVirtualSpace = null;
    private Boolean myIsCaretInsideTabs = null;
    private Boolean myIsCaretBlinking = null;
    private Integer myCaretBlinkingPeriod = null;
    private Boolean myIsRightMarginShown = null;
    private Integer myRightMargin = null;
    private Boolean myAreLineNumbersShown = null;
    private Boolean myIsFoldingOutlineShown = null;
    private Boolean myIsSmartHome = null;
    private Boolean myIsBlockCursor = null;
    private Boolean myIsWhitespacesShown = null;
    private Boolean myIndentGuidesShown = null;
    private Boolean myIsAnimatedScrolling = null;
    private Boolean myIsAdditionalPageAtBottom = null;
    private Boolean myIsDndEnabled = null;
    private Boolean myIsWheelFontChangeEnabled = null;
    private Boolean myIsMouseClickSelectionHonorsCamelWords = null;
    private Boolean myIsRenameVariablesInplace = null;
    private Boolean myIsRefrainFromScrolling = null;

    public SettingsImpl(@Nullable EditorEx editor) {
        this.myEditor = editor;
    }

    public boolean isRightMarginShown() {
        return this.myIsRightMarginShown != null ? this.myIsRightMarginShown.booleanValue() : EditorSettingsExternalizable.getInstance().isRightMarginShown();
    }

    public void setRightMarginShown(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIsRightMarginShown)) {
            return;
        }
        this.myIsRightMarginShown = newValue;
        this.fireEditorRefresh();
    }

    public boolean isWhitespacesShown() {
        return this.myIsWhitespacesShown != null ? this.myIsWhitespacesShown.booleanValue() : EditorSettingsExternalizable.getInstance().isWhitespacesShown();
    }

    public void setWhitespacesShown(boolean val) {
        this.myIsWhitespacesShown = val;
    }

    public boolean isIndentGuidesShown() {
        return this.myIndentGuidesShown != null ? this.myIndentGuidesShown.booleanValue() : EditorSettingsExternalizable.getInstance().isIndentGuidesShown();
    }

    public void setIndentGuidesShown(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIndentGuidesShown)) {
            return;
        }
        this.myIndentGuidesShown = newValue;
        this.fireEditorRefresh();
    }

    public boolean isLineNumbersShown() {
        return this.myAreLineNumbersShown != null ? this.myAreLineNumbersShown.booleanValue() : EditorSettingsExternalizable.getInstance().isLineNumbersShown();
    }

    public void setLineNumbersShown(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myAreLineNumbersShown)) {
            return;
        }
        this.myAreLineNumbersShown = newValue;
        this.fireEditorRefresh();
    }

    public int getRightMargin(Project project) {
        return this.myRightMargin != null ? this.myRightMargin.intValue() : CodeStyleFacade.getInstance((Project)project).getRightMargin();
    }

    public void setRightMargin(int rightMargin) {
        Integer newValue = rightMargin;
        if (newValue.equals(this.myRightMargin)) {
            return;
        }
        this.myRightMargin = newValue;
        this.fireEditorRefresh();
    }

    public int getAdditionalLinesCount() {
        return this.myAdditionalLinesCount;
    }

    public void setAdditionalLinesCount(int additionalLinesCount) {
        if (this.myAdditionalLinesCount == additionalLinesCount) {
            return;
        }
        this.myAdditionalLinesCount = additionalLinesCount;
        this.fireEditorRefresh();
    }

    public int getAdditionalColumnsCount() {
        return this.myAdditionalColumnsCount;
    }

    public void setAdditionalColumnsCount(int additinalColumnsCount) {
        if (this.myAdditionalColumnsCount == additinalColumnsCount) {
            return;
        }
        this.myAdditionalColumnsCount = additinalColumnsCount;
        this.fireEditorRefresh();
    }

    public boolean isLineMarkerAreaShown() {
        return this.myLineMarkerAreaShown;
    }

    public void setLineMarkerAreaShown(boolean lineMarkerAreaShown) {
        if (this.myLineMarkerAreaShown == lineMarkerAreaShown) {
            return;
        }
        this.myLineMarkerAreaShown = lineMarkerAreaShown;
        this.fireEditorRefresh();
    }

    public boolean isFoldingOutlineShown() {
        return this.myIsFoldingOutlineShown != null ? this.myIsFoldingOutlineShown.booleanValue() : EditorSettingsExternalizable.getInstance().isFoldingOutlineShown();
    }

    public void setFoldingOutlineShown(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIsFoldingOutlineShown)) {
            return;
        }
        this.myIsFoldingOutlineShown = newValue;
        this.fireEditorRefresh();
    }

    public boolean isUseTabCharacter(Project project) {
        FileType fileType = this.getFileType();
        return this.myUseTabCharacter != null ? this.myUseTabCharacter.booleanValue() : CodeStyleFacade.getInstance((Project)project).useTabCharacter(fileType);
    }

    public void setUseTabCharacter(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myUseTabCharacter)) {
            return;
        }
        this.myUseTabCharacter = newValue;
        this.fireEditorRefresh();
    }

    public void reinitSettings() {
        this.myCachedTabSize = null;
    }

    public int getTabSize(Project project) {
        if (this.myTabSize != null) {
            return this.myTabSize;
        }
        if (this.myCachedTabSize != null) {
            return this.myCachedTabSize;
        }
        FileType fileType = this.getFileType();
        int tabSize = project == null || project.isDisposed() ? 0 : CodeStyleFacade.getInstance((Project)project).getTabSize(fileType);
        this.myCachedTabSize = tabSize;
        return tabSize;
    }

    @Nullable
    private FileType getFileType() {
        VirtualFile file = this.myEditor == null ? null : this.myEditor.getVirtualFile();
        return file == null ? null : file.getFileType();
    }

    public void setTabSize(int tabSize) {
        Integer newValue = tabSize;
        if (newValue.equals(this.myTabSize)) {
            return;
        }
        this.myTabSize = newValue;
        this.fireEditorRefresh();
    }

    public boolean isSmartHome() {
        return this.myIsSmartHome != null ? this.myIsSmartHome.booleanValue() : EditorSettingsExternalizable.getInstance().isSmartHome();
    }

    public void setSmartHome(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIsSmartHome)) {
            return;
        }
        this.myIsSmartHome = newValue;
        this.fireEditorRefresh();
    }

    public boolean isVirtualSpace() {
        if (this.myEditor != null && this.myEditor.isColumnMode()) {
            return true;
        }
        return this.myIsVirtualSpace != null ? this.myIsVirtualSpace.booleanValue() : EditorSettingsExternalizable.getInstance().isVirtualSpace();
    }

    public void setVirtualSpace(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIsVirtualSpace)) {
            return;
        }
        this.myIsVirtualSpace = newValue;
        this.fireEditorRefresh();
    }

    public boolean isAdditionalPageAtBottom() {
        return this.myIsAdditionalPageAtBottom != null ? this.myIsAdditionalPageAtBottom.booleanValue() : EditorSettingsExternalizable.getInstance().isAdditionalPageAtBottom();
    }

    public void setAdditionalPageAtBottom(boolean val) {
        this.myIsAdditionalPageAtBottom = val;
    }

    public boolean isCaretInsideTabs() {
        if (this.myEditor != null && this.myEditor.isColumnMode()) {
            return true;
        }
        return this.myIsCaretInsideTabs != null ? this.myIsCaretInsideTabs.booleanValue() : EditorSettingsExternalizable.getInstance().isCaretInsideTabs();
    }

    public void setCaretInsideTabs(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIsCaretInsideTabs)) {
            return;
        }
        this.myIsCaretInsideTabs = newValue;
        this.fireEditorRefresh();
    }

    public boolean isBlockCursor() {
        return this.myIsBlockCursor != null ? this.myIsBlockCursor.booleanValue() : EditorSettingsExternalizable.getInstance().isBlockCursor();
    }

    public void setBlockCursor(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIsBlockCursor)) {
            return;
        }
        this.myIsBlockCursor = newValue;
        this.fireEditorRefresh();
    }

    public int getLineCursorWidth() {
        return this.myLineCursorWidth;
    }

    public void setLineCursorWidth(int width) {
        this.myLineCursorWidth = width;
    }

    public boolean isAnimatedScrolling() {
        return this.myIsAnimatedScrolling != null ? this.myIsAnimatedScrolling.booleanValue() : EditorSettingsExternalizable.getInstance().isSmoothScrolling();
    }

    public void setAnimatedScrolling(boolean val) {
        this.myIsAnimatedScrolling = val ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isCamelWords() {
        return this.myIsCamelWords != null ? this.myIsCamelWords.booleanValue() : EditorSettingsExternalizable.getInstance().isCamelWords();
    }

    public void setCamelWords(boolean val) {
        this.myIsCamelWords = val ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isBlinkCaret() {
        return this.myIsCaretBlinking != null ? this.myIsCaretBlinking.booleanValue() : EditorSettingsExternalizable.getInstance().isBlinkCaret();
    }

    public void setBlinkCaret(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIsCaretBlinking)) {
            return;
        }
        this.myIsCaretBlinking = newValue;
        this.fireEditorRefresh();
    }

    public int getCaretBlinkPeriod() {
        return this.myCaretBlinkingPeriod != null ? this.myCaretBlinkingPeriod.intValue() : EditorSettingsExternalizable.getInstance().getBlinkPeriod();
    }

    public void setCaretBlinkPeriod(int blinkPeriod) {
        Integer newValue = blinkPeriod;
        if (newValue.equals(this.myCaretBlinkingPeriod)) {
            return;
        }
        this.myCaretBlinkingPeriod = newValue;
        this.fireEditorRefresh();
    }

    public boolean isDndEnabled() {
        return this.myIsDndEnabled != null ? this.myIsDndEnabled.booleanValue() : EditorSettingsExternalizable.getInstance().isDndEnabled();
    }

    public void setDndEnabled(boolean val) {
        this.myIsDndEnabled = val ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isWheelFontChangeEnabled() {
        return this.myIsWheelFontChangeEnabled != null ? this.myIsWheelFontChangeEnabled.booleanValue() : EditorSettingsExternalizable.getInstance().isWheelFontChangeEnabled();
    }

    public void setWheelFontChangeEnabled(boolean val) {
        this.myIsWheelFontChangeEnabled = val ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isMouseClickSelectionHonorsCamelWords() {
        return this.myIsMouseClickSelectionHonorsCamelWords != null ? this.myIsMouseClickSelectionHonorsCamelWords.booleanValue() : EditorSettingsExternalizable.getInstance().isMouseClickSelectionHonorsCamelWords();
    }

    public void setMouseClickSelectionHonorsCamelWords(boolean val) {
        this.myIsMouseClickSelectionHonorsCamelWords = val ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isVariableInplaceRenameEnabled() {
        return this.myIsRenameVariablesInplace != null ? this.myIsRenameVariablesInplace.booleanValue() : EditorSettingsExternalizable.getInstance().isVariableInplaceRenameEnabled();
    }

    public void setVariableInplaceRenameEnabled(boolean val) {
        this.myIsRenameVariablesInplace = val ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isRefrainFromScrolling() {
        if (this.myIsRefrainFromScrolling != null) {
            return this.myIsRefrainFromScrolling;
        }
        return EditorSettingsExternalizable.getInstance().isRefrainFromScrolling();
    }

    public void setRefrainFromScrolling(boolean b) {
        this.myIsRefrainFromScrolling = b ? Boolean.TRUE : Boolean.FALSE;
    }

    private void fireEditorRefresh() {
        if (this.myEditor != null) {
            this.myEditor.reinitSettings();
        }
    }
}

