/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public class IndentSelectionAction
extends EditorAction {
    public IndentSelectionAction() {
        super((EditorActionHandler)new Handler());
    }

    public void update(Editor editor, Presentation presentation, DataContext dataContext) {
        presentation.setEnabled(IndentSelectionAction.isEnabled(editor));
    }

    private static boolean isEnabled(Editor editor) {
        return editor.getSelectionModel().hasSelection() && !editor.isOneLineMode();
    }

    public static void indentSelection(Editor editor, Project project) {
        VirtualFile vFile;
        int endIndex;
        if (!editor.getSelectionModel().hasSelection()) {
            return;
        }
        int oldSelectionStart = editor.getSelectionModel().getSelectionStart();
        int oldSelectionEnd = editor.getSelectionModel().getSelectionEnd();
        Document document = editor.getDocument();
        int startIndex = document.getLineNumber(oldSelectionStart);
        if (startIndex == -1) {
            startIndex = document.getLineCount() - 1;
        }
        if ((endIndex = document.getLineNumber(oldSelectionEnd)) > 0 && document.getLineStartOffset(endIndex) == oldSelectionEnd) {
            --endIndex;
        }
        if (endIndex == -1) {
            endIndex = document.getLineCount() - 1;
        }
        FileType fileType = (vFile = FileDocumentManager.getInstance().getFile(document)) == null ? null : FileTypeManager.getInstance().getFileTypeByFile(vFile);
        int blockIndent = CodeStyleFacade.getInstance((Project)project).getIndentSize(fileType);
        IndentSelectionAction.doIndent(endIndex, startIndex, document, project, editor, blockIndent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doIndent(int endIndex, int startIndex, Document document, Project project, Editor editor, int blockIndent) {
        boolean bulkMode;
        boolean bl = bulkMode = endIndex - startIndex > 50;
        if (bulkMode) {
            ((DocumentEx)document).setInBulkUpdate(true);
        }
        try {
            for (int i = startIndex; i <= endIndex; ++i) {
                EditorActionUtil.indentLine(project, editor, i, blockIndent);
            }
        }
        finally {
            if (bulkMode) {
                ((DocumentEx)document).setInBulkUpdate(false);
            }
        }
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
            IndentSelectionAction.indentSelection(editor, project);
        }
    }
}

