/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.EditingSides;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.splitter.DiffDividerPaint;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DiffDivider
extends JComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.util.DiffDivider");
    private final Editor[] myEditors = new Editor[2];
    private final FragmentSide myLeftSide;
    private DiffDividerPaint myPaint = null;
    private static final int ourWidth = 30;
    private final VisibleAreaListener myVisibleAreaListener = new VisibleAreaListener(){

        public void visibleAreaChanged(VisibleAreaEvent e) {
            DiffDivider.this.repaint();
        }
    };

    public DiffDivider(FragmentSide leftSide) {
        this.myLeftSide = leftSide;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(30, 1);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.myPaint != null) {
            this.myPaint.paint(g, this);
        }
    }

    public DiffDividerPaint getPaint() {
        return this.myPaint;
    }

    public void stopListenEditors() {
        for (int i = 0; i < this.myEditors.length; ++i) {
            Editor editor = this.myEditors[i];
            if (editor == null) continue;
            editor.getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
            this.myEditors[i] = null;
        }
        this.myPaint = null;
        this.myEditors[0] = null;
        this.myEditors[1] = null;
    }

    public void listenEditors(@NotNull EditingSides sides) {
        if (sides == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/diff/impl/util/DiffDivider.listenEditors must not be null");
        }
        this.stopListenEditors();
        this.myPaint = new DiffDividerPaint(sides, this.myLeftSide);
        this.myEditors[0] = sides.getEditor(FragmentSide.SIDE1);
        this.myEditors[1] = sides.getEditor(FragmentSide.SIDE2);
        if (this.myEditors[0] == null || this.myEditors[1] == null) {
            LOG.error(this.myEditors[1] + " " + this.myEditors[1]);
        }
        for (Editor editor : this.myEditors) {
            editor.getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        }
    }
}

