/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.splitter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.fragments.LineBlock;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.splitter.Interval;
import com.intellij.openapi.diff.impl.splitter.LinearTransformation;
import com.intellij.openapi.diff.impl.splitter.Trapezium;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.util.containers.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class LineBlocks {
    public static final LineBlocks EMPTY = new LineBlocks(SimpleIntervalProvider.EMPTY, new TextDiffTypeEnum[0]);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.splitter.LineBlocks");
    private final IntervalsProvider myIntervalsProvider;
    private final TextDiffTypeEnum[] myTypes;

    private LineBlocks(IntervalsProvider intervalsProvider, TextDiffTypeEnum[] types) {
        this.myIntervalsProvider = intervalsProvider;
        this.myTypes = types;
    }

    public Interval getVisibleIndecies(Trapezium visibleArea) {
        Interval visible1 = visibleArea.getBase1();
        Interval visible2 = visibleArea.getBase2();
        Interval[] intervals1 = this.getIntervals(FragmentSide.SIDE1);
        Interval[] intervals2 = this.getIntervals(FragmentSide.SIDE2);
        int index = Math.min(LineBlocks.getMaxStartedIndex(intervals1, visible1.getStart()), LineBlocks.getMaxStartedIndex(intervals2, visible2.getStart()));
        int lastIndex = Math.max(LineBlocks.getMinNotStartedIndex(intervals1, visible1.getEnd()), LineBlocks.getMinNotStartedIndex(intervals2, visible2.getEnd()));
        return Interval.fromTo(index, lastIndex);
    }

    public Trapezium getTrapezium(int index) {
        return new Trapezium(this.getIntervals(FragmentSide.SIDE1)[index], this.getIntervals(FragmentSide.SIDE2)[index]);
    }

    public TextDiffTypeEnum getType(int index) {
        return this.myTypes[index];
    }

    public int getCount() {
        return this.getBegginings(FragmentSide.SIDE1).length;
    }

    public int[] getBegginings(FragmentSide side) {
        IntArrayList result = new IntArrayList(this.getIntervals(side).length);
        int previousBeginning = Integer.MIN_VALUE;
        Interval[] sideIntervals = this.getIntervals(side);
        for (int i = 0; i < sideIntervals.length; ++i) {
            int start = sideIntervals[i].getStart();
            if (start != previousBeginning) {
                result.add(start);
            }
            previousBeginning = start;
        }
        return result.toArray();
    }

    static int getMaxStartedIndex(Interval[] intervals, int start) {
        int index;
        for (int i = index = LineBlocks.getMinIndex(intervals, start, Interval.START_COMPARATOR); i > 0; --i) {
            if (intervals[i - 1].getEnd() > start) continue;
            return i;
        }
        return 0;
    }

    static int getMinNotStartedIndex(Interval[] intervals, int end) {
        int index;
        for (int i = index = LineBlocks.getMinIndex(intervals, end, Interval.END_COMPARATOR); i < intervals.length; ++i) {
            if (intervals[i].getStart() < end) continue;
            return i;
        }
        return intervals.length;
    }

    private static int getMinIndex(Interval[] intervals, int start, Comparator comparator) {
        int index = Arrays.binarySearch(intervals, new Integer(start), comparator);
        return index >= 0 ? index : -index - 1;
    }

    public int transform(FragmentSide masterSide, int location) {
        return this.transform(location, this.getIntervals(masterSide), this.getIntervals(masterSide.otherSide()));
    }

    public Interval[] getIntervals(FragmentSide side) {
        return this.myIntervalsProvider.getIntervals(side);
    }

    private int transform(int location, Interval[] domain, Interval[] range) {
        Interval rightInterval;
        Interval leftInterval;
        if (domain.length == 0) {
            if (range.length != 0) {
                LOG.error("" + range.length);
            }
            return location;
        }
        int count = this.getIntervals(FragmentSide.SIDE1).length;
        LOG.assertTrue(count == this.getIntervals(FragmentSide.SIDE2).length);
        int index = LineBlocks.getMaxStartedIndex(domain, location);
        if (index == 0) {
            if (domain[0].contains(location)) {
                leftInterval = domain[0];
                rightInterval = range[0];
            } else {
                leftInterval = Interval.fromTo(0, domain[0].getStart());
                rightInterval = Interval.fromTo(0, range[0].getStart());
            }
        } else if (index == count) {
            leftInterval = Interval.toInf(domain[count - 1].getEnd());
            rightInterval = Interval.toInf(range[count - 1].getEnd());
        } else if (domain[index].contains(location)) {
            leftInterval = domain[index];
            rightInterval = range[index];
        } else {
            leftInterval = Interval.fromTo(domain[index - 1].getEnd(), domain[index].getStart());
            rightInterval = Interval.fromTo(range[index - 1].getEnd(), range[index].getStart());
        }
        return LinearTransformation.oneToOne(location, leftInterval.getStart(), rightInterval);
    }

    public static LineBlocks fromLineFragments(ArrayList<LineFragment> lines) {
        ArrayList<LineFragment> filtered = new ArrayList<LineFragment>();
        for (LineFragment fragment : lines) {
            if (fragment.getType() == null) continue;
            filtered.add(fragment);
        }
        return LineBlocks.createLineBlocks(filtered.toArray(new LineBlock[filtered.size()]));
    }

    static LineBlocks createLineBlocks(LineBlock[] blocks) {
        Arrays.sort(blocks, LineBlock.COMPARATOR);
        Interval[] intervals1 = new Interval[blocks.length];
        Interval[] intervals2 = new Interval[blocks.length];
        TextDiffTypeEnum[] types = new TextDiffTypeEnum[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            LineBlock block = blocks[i];
            intervals1[i] = new Interval(block.getStartingLine1(), block.getModifiedLines1());
            intervals2[i] = new Interval(block.getStartingLine2(), block.getModifiedLines2());
            types[i] = block.getType();
        }
        return LineBlocks.create(intervals1, intervals2, types);
    }

    private static LineBlocks create(Interval[] intervals1, Interval[] intervals2, TextDiffTypeEnum[] types) {
        return new LineBlocks(new SimpleIntervalProvider(intervals1, intervals2), types);
    }

    public static LineBlocks fromChanges(ArrayList<Change> changes) {
        ArrayList<Interval> intervals1 = new ArrayList<Interval>();
        ArrayList<Interval> intervals2 = new ArrayList<Interval>();
        ArrayList<TextDiffTypeEnum> types = new ArrayList<TextDiffTypeEnum>();
        for (Change change : changes) {
            if (!change.isValid()) continue;
            int start1 = change.getChangeSide(FragmentSide.SIDE1).getStartLine();
            int start2 = change.getChangeSide(FragmentSide.SIDE2).getStartLine();
            int end1 = change.getChangeSide(FragmentSide.SIDE1).getEndLine();
            intervals1.add(Interval.fromTo(start1, end1));
            int end2 = change.getChangeSide(FragmentSide.SIDE2).getEndLine();
            intervals2.add(Interval.fromTo(start2, end2));
            types.add(change.getType().getTypeKey().getType());
        }
        return LineBlocks.create(intervals1.toArray(new Interval[intervals1.size()]), intervals2.toArray(new Interval[intervals2.size()]), types.toArray(new TextDiffTypeEnum[types.size()]));
    }

    public TextDiffTypeEnum[] getTypes() {
        return this.myTypes;
    }

    public static class SimpleIntervalProvider
    implements IntervalsProvider {
        private final Interval[][] myIntervals = new Interval[2][];
        public static final IntervalsProvider EMPTY = new SimpleIntervalProvider(new Interval[0], new Interval[0]);

        public SimpleIntervalProvider(Interval[] intervals1, Interval[] intervals2) {
            this.myIntervals[0] = intervals1;
            this.myIntervals[1] = intervals2;
        }

        @Override
        public Interval[] getIntervals(FragmentSide side) {
            return this.myIntervals[side.getIndex()];
        }
    }

    public static interface IntervalsProvider {
        public Interval[] getIntervals(FragmentSide var1);
    }
}

