/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.MergePanel2;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

class OpenPartialDiffAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.incrementalMerge.ui.OpenPartialDiffAction");
    private final int myLeftIndex;
    private final int myRightIndex;

    public OpenPartialDiffAction(int leftIndex, int rightIndex, Icon icon) {
        super("", null, icon);
        this.myLeftIndex = leftIndex;
        this.myRightIndex = rightIndex;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        MergePanel2 mergePanel = MergePanel2.fromDataContext(dataContext);
        Project project = OpenPartialDiffAction.projectFromDataContext(dataContext);
        Editor leftEditor = mergePanel.getEditor(this.myLeftIndex);
        Editor rightEditor = mergePanel.getEditor(this.myRightIndex);
        FileType type = mergePanel.getContentType();
        SimpleDiffRequest diffData = new SimpleDiffRequest(project, this.composeName());
        diffData.setContents((DiffContent)new DocumentContent(project, leftEditor.getDocument(), type), (DiffContent)new DocumentContent(project, rightEditor.getDocument(), type));
        diffData.setContentTitles(mergePanel.getVersionTitle(this.myLeftIndex), mergePanel.getVersionTitle(this.myRightIndex));
        LOG.assertTrue(DiffManagerImpl.INTERNAL_DIFF.canShow((DiffRequest)diffData));
        DiffManagerImpl.INTERNAL_DIFF.show((DiffRequest)diffData);
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        MergePanel2 mergePanel = MergePanel2.fromDataContext(dataContext);
        Project project = OpenPartialDiffAction.projectFromDataContext(dataContext);
        Presentation presentation = e.getPresentation();
        if (mergePanel == null || project == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        presentation.setVisible(true);
        Editor leftEditor = mergePanel.getEditor(this.myLeftIndex);
        Editor rightEditor = mergePanel.getEditor(this.myRightIndex);
        if (leftEditor == null || rightEditor == null) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setText(this.composeName());
        presentation.setEnabled(true);
    }

    private String composeName() {
        if (this.myLeftIndex == 1 && this.myRightIndex == 0) {
            return DiffBundle.message((String)"merge.partial.diff.action.name.0.1", (Object[])new Object[0]);
        }
        if (this.myLeftIndex == 1 && this.myRightIndex == 2) {
            return DiffBundle.message((String)"merge.partial.diff.action.name.1.2", (Object[])new Object[0]);
        }
        return DiffBundle.message((String)"merge.partial.diff.action.name", (Object[])new Object[0]);
    }

    @Nullable
    private static Project projectFromDataContext(DataContext dataContext) {
        return (Project)PlatformDataKeys.PROJECT.getData(dataContext);
    }
}

