/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.highlighting;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.diff.actions.MergeActionGroup;
import com.intellij.openapi.diff.actions.MergeOperations;
import com.intellij.openapi.diff.impl.EditorSource;
import com.intellij.openapi.diff.impl.fragments.Fragment;
import com.intellij.openapi.diff.impl.highlighting.LineRenderer;
import com.intellij.openapi.diff.impl.util.GutterActionRenderer;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.HashSet;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class DiffMarkup
implements EditorSource {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.highlighting.EditorTextAppender");
    private static final int LAYER = 5999;
    private final ArrayList<RangeHighlighter> myHighLighters = new ArrayList();
    private final HashSet<RangeHighlighter> myActionHighlighters = new HashSet();
    private final Project myProject;
    private final ArrayList<Disposable> myDisposables = new ArrayList();
    private boolean myDisposed = false;

    protected DiffMarkup(Project project) {
        this.myProject = project;
    }

    private MarkupModel getMarkupModel() {
        EditorEx editor = this.getEditor();
        return editor == null ? null : editor.getMarkupModel();
    }

    public void highlightText(Fragment fragment, boolean drawBorder) {
        RangeHighlighter rangeMarker;
        TextDiffTypeEnum diffTypeEnum = fragment.getType();
        if (diffTypeEnum == null) {
            return;
        }
        TextDiffType type = TextDiffType.create(diffTypeEnum);
        if (type == null) {
            return;
        }
        TextRange range = fragment.getRange(this.getSide());
        TextAttributes attributes = type.getTextAttributes(this.getEditor());
        if (!drawBorder && range.getLength() == 0) {
            return;
        }
        if (drawBorder && range.getLength() == 0) {
            TextAttributes textAttributes = new TextAttributes(null, null, attributes.getBackgroundColor(), EffectType.BOXED, 0);
            rangeMarker = this.getMarkupModel().addRangeHighlighter(range.getStartOffset(), range.getStartOffset(), 5999, textAttributes, HighlighterTargetArea.EXACT_RANGE);
        } else {
            rangeMarker = this.getMarkupModel().addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 5999, attributes, HighlighterTargetArea.EXACT_RANGE);
        }
        Color stripeBarColor = attributes.getErrorStripeColor();
        if (stripeBarColor != null) {
            rangeMarker.setErrorStripeMarkColor(stripeBarColor);
        }
        this.saveHighlighter(rangeMarker);
    }

    public void addLineMarker(int line, TextAttributesKey type) {
        RangeHighlighter marker = this.createLineMarker(type, line);
        if (marker == null) {
            return;
        }
        this.saveHighlighter(marker);
        marker.setLineMarkerRenderer(LineRenderer.bottom());
    }

    private RangeHighlighter createLineMarker(TextAttributesKey type, int line) {
        Color color = this.getLineSeparatorColorForType(type);
        RangeHighlighter lastHighlighter = this.getLastHighlighter();
        if (lastHighlighter != null && lastHighlighter.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE && SeparatorPlacement.BOTTOM == lastHighlighter.getLineSeparatorPlacement()) {
            int lastLine = this.getDocument().getLineNumber(lastHighlighter.getStartOffset());
            LOG.assertTrue(lastLine <= line);
            if (lastLine == line) {
                Color lastLineColor = lastHighlighter.getLineSeparatorColor();
                if (color == Color.GRAY || lastLineColor != Color.GRAY) {
                    return null;
                }
                this.removeHighlighter(lastHighlighter);
            }
        }
        RangeHighlighter marker = this.getMarkupModel().addLineHighlighter(line, 5999, null);
        marker.setLineSeparatorColor(color);
        marker.setLineSeparatorPlacement(SeparatorPlacement.BOTTOM);
        if (type == DiffColors.DIFF_DELETED) {
            marker.setErrorStripeMarkColor(color);
        }
        return marker;
    }

    private void removeHighlighter(RangeHighlighter highlighter) {
        this.getMarkupModel().removeHighlighter(highlighter);
        this.myHighLighters.remove(highlighter);
        this.myActionHighlighters.remove((Object)highlighter);
    }

    private Color getLineSeparatorColorForType(TextAttributesKey type) {
        LOG.assertTrue(type == DiffColors.DIFF_DELETED || type == DiffColors.DIFF_MODIFIED || type == null);
        if (type == null || type == DiffColors.DIFF_MODIFIED) {
            return Color.GRAY;
        }
        return TextDiffType.DELETED.getTextBackground(this.getEditor());
    }

    private RangeHighlighter getLastHighlighter() {
        int size = this.myHighLighters.size();
        return size > 0 ? this.myHighLighters.get(size - 1) : null;
    }

    private void saveHighlighter(@NotNull RangeHighlighter marker) {
        if (marker == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/diff/impl/highlighting/DiffMarkup.saveHighlighter must not be null");
        }
        this.myHighLighters.add(marker);
    }

    public Document getDocument() {
        return this.getEditor().getDocument();
    }

    public void addAction(MergeOperations.Operation operation, int lineStartOffset) {
        RangeHighlighter highlighter = this.createAction(operation, lineStartOffset);
        if (highlighter != null) {
            this.myActionHighlighters.add((Object)highlighter);
        }
    }

    private RangeHighlighter createAction(MergeOperations.Operation operation, int lineStartOffset) {
        if (operation == null) {
            return null;
        }
        RangeHighlighter highlighter = this.getMarkupModel().addRangeHighlighter(lineStartOffset, lineStartOffset, 3000, new TextAttributes(null, null, null, null, 0), HighlighterTargetArea.LINES_IN_RANGE);
        MergeActionGroup.OperationAction action = new MergeActionGroup.OperationAction(operation);
        highlighter.setGutterIconRenderer((GutterIconRenderer)new GutterActionRenderer(action));
        return highlighter;
    }

    public void resetHighlighters() {
        this.removeHighlighters(this.myHighLighters);
        this.removeHighlighters((Collection<RangeHighlighter>)this.myActionHighlighters);
    }

    private void removeHighlighters(Collection<RangeHighlighter> highlighters) {
        MarkupModel markupModel = this.getMarkupModel();
        if (markupModel != null) {
            for (RangeHighlighter highlighter : highlighters) {
                markupModel.removeHighlighter(highlighter);
            }
        }
        highlighters.clear();
    }

    protected Project getProject() {
        return this.myProject;
    }

    protected void disposeEditor() {
        this.resetHighlighters();
        for (Disposable disposable : this.myDisposables) {
            Disposer.dispose((Disposable)disposable);
        }
        this.myDisposables.clear();
    }

    @Override
    public void addDisposable(Disposable disposable) {
        this.myDisposables.add(disposable);
    }

    public String getText() {
        return this.getDocument().getText();
    }

    protected final boolean isDisposed() {
        return this.myDisposed;
    }

    public final void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.doDispose();
        this.myDisposed = true;
    }

    protected void doDispose() {
        this.disposeEditor();
    }

    public void removeActions() {
        this.removeHighlighters((Collection<RangeHighlighter>)this.myActionHighlighters);
    }
}

