/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.ex;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class DiffStatusBar
extends JPanel {
    public static final List<? extends LegendTypeDescriptor> DEFAULT_TYPES = Arrays.asList(new LegendTypeDescriptorImpl(VcsBundle.message((String)"diff.type.name.modified", (Object[])new Object[0]), FileStatus.COLOR_MODIFIED), new LegendTypeDescriptorImpl(VcsBundle.message((String)"diff.type.name.added", (Object[])new Object[0]), FileStatus.COLOR_ADDED), new LegendTypeDescriptorImpl(VcsBundle.message((String)"diff.type.name.deleted", (Object[])new Object[0]), FileStatus.COLOR_MISSING));
    private final Collection<JComponent> myLabels = new ArrayList<JComponent>();
    private final JLabel myTextLabel = new JLabel("", 0);
    private static final int COMP_HEIGHT = 40;
    private EditorColorsScheme myColorScheme = null;

    public <T extends LegendTypeDescriptor> DiffStatusBar(List<T> types) {
        for (LegendTypeDescriptor differenceType : types) {
            this.addDiffType(differenceType);
        }
        this.initGui();
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
    }

    private void addDiffType(LegendTypeDescriptor diffType) {
        this.addComponent(diffType);
    }

    private void addComponent(final LegendTypeDescriptor diffType) {
        JPanel component = new JPanel(){

            @Override
            public void paint(Graphics g) {
                this.setBackground(UIUtil.getTableHeaderBackground());
                super.paint(g);
                FontMetrics metrics = this.getFontMetrics(this.getFont());
                EditorColorsScheme colorScheme = DiffStatusBar.this.myColorScheme != null ? DiffStatusBar.this.myColorScheme : EditorColorsManager.getInstance().getGlobalScheme();
                g.setColor(diffType.getLegendColor(colorScheme));
                g.fill3DRect(10, (this.getHeight() - 10) / 2, 35, 10, true);
                Font font = g.getFont();
                if (font.getStyle() != 0) {
                    font = font.deriveFont(0);
                }
                g.setFont(font);
                g.setColor(UIUtil.getLabelForeground());
                int textBaseline = (this.getHeight() - metrics.getHeight()) / 2 + metrics.getAscent();
                g.drawString(diffType.getDisplayName(), 67, textBaseline);
            }

            @Override
            public Dimension getPreferredSize() {
                FontMetrics metrics = this.getFontMetrics(this.getFont());
                return new Dimension((int)(70.0 + metrics.getStringBounds(diffType.getDisplayName(), this.getGraphics()).getWidth()), 40);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.myLabels.add(component);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension p = super.getPreferredSize();
        Dimension m = super.getMinimumSize();
        return new Dimension(m.width, p.height);
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension p = super.getPreferredSize();
        Dimension m = super.getMaximumSize();
        return new Dimension(m.width, p.height);
    }

    public void setText(String text) {
        this.myTextLabel.setText(text);
    }

    private void initGui() {
        this.setLayout(new BorderLayout());
        Border emptyBorder = BorderFactory.createEmptyBorder(3, 2, 5, 2);
        this.setBorder(emptyBorder);
        this.add((Component)this.myTextLabel, "West");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        JPanel panel = new JPanel(new GridLayout(1, this.myLabels.size(), 0, 0));
        for (JComponent myLabel : this.myLabels) {
            panel.add(myLabel);
        }
        panel.setMaximumSize(panel.getPreferredSize());
        box.add(panel);
        box.add(Box.createHorizontalGlue());
        this.add((Component)box, "Center");
    }

    public void setColorScheme(EditorColorsScheme colorScheme) {
        EditorColorsScheme oldScheme = this.myColorScheme;
        this.myColorScheme = colorScheme;
        if (oldScheme != colorScheme) {
            this.repaint();
        }
    }

    static class LegendTypeDescriptorImpl
    implements LegendTypeDescriptor {
        private final String myDisplayName;
        private final Color myColor;

        LegendTypeDescriptorImpl(String displayName, Color color) {
            this.myDisplayName = displayName;
            this.myColor = color;
        }

        @Override
        public String getDisplayName() {
            return this.myDisplayName;
        }

        @Override
        public Color getLegendColor(EditorColorsScheme colorScheme) {
            return this.myColor;
        }
    }

    public static interface LegendTypeDescriptor {
        public String getDisplayName();

        public Color getLegendColor(EditorColorsScheme var1);
    }
}

