/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageChooser;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageAnnotationsDefaultValues;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ComponentRoamingManager;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.InvalidComponentDataException;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RoamingTypeDisabled;
import com.intellij.openapi.util.RoamingTypePerPlatform;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionCache;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.io.fs.IFile;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ComponentStoreImpl
implements IComponentStore {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.components.ComponentStoreImpl");
    private final Map<String, Object> myComponents = Collections.synchronizedMap(new TreeMap());
    private final List<SettingsSavingComponent> mySettingsSavingComponents = Collections.synchronizedList(new ArrayList());
    @Nullable
    private SaveSessionImpl mySession;

    ComponentStoreImpl() {
    }

    @Deprecated
    @Nullable
    private StateStorage getStateStorage(@NotNull Storage storageSpec) throws StateStorage.StateStorageException {
        if (storageSpec == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ComponentStoreImpl.getStateStorage must not be null");
        }
        return this.getStateStorageManager().getStateStorage(storageSpec);
    }

    @Deprecated
    @Nullable
    private StateStorage getOldStorage(Object component, String componentName, StateStorageOperation operation) throws StateStorage.StateStorageException {
        return this.getStateStorageManager().getOldStorage(component, componentName, operation);
    }

    protected StateStorage getDefaultsStorage() {
        throw new UnsupportedOperationException("Method getDefaultsStorage is not supported in " + this.getClass());
    }

    @Override
    public String initComponent(final @NotNull Object component, boolean service) {
        boolean isSerializable;
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ComponentStoreImpl.initComponent must not be null");
        }
        boolean bl = isSerializable = component instanceof JDOMExternalizable || component instanceof PersistentStateComponent || component instanceof SettingsSavingComponent;
        if (!isSerializable) {
            return null;
        }
        if (component instanceof SettingsSavingComponent) {
            SettingsSavingComponent settingsSavingComponent = (SettingsSavingComponent)component;
            this.mySettingsSavingComponents.add(settingsSavingComponent);
        }
        final String[] componentName = new String[]{null};
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (component instanceof PersistentStateComponent) {
                    componentName[0] = ComponentStoreImpl.this.initPersistentComponent((PersistentStateComponent)component, false);
                } else if (component instanceof JDOMExternalizable) {
                    componentName[0] = ComponentStoreImpl.this.initJdomExternalizable((JDOMExternalizable)component);
                }
            }
        };
        ApplicationEx applicationEx = ApplicationManagerEx.getApplicationEx();
        if (applicationEx.isUnitTestMode()) {
            r.run();
        } else {
            applicationEx.runReadAction(r);
        }
        return componentName[0];
    }

    @Override
    public boolean isSaving() {
        return this.mySession != null;
    }

    @Override
    @NotNull
    public IComponentStore.SaveSession startSave() throws IOException {
        SaveSessionImpl saveSessionImpl;
        try {
            SaveSessionImpl session = this.createSaveSession();
            try {
                session.commit();
            }
            catch (Throwable e) {
                try {
                    session.reset();
                }
                catch (Exception e1_ignored) {
                    LOG.info((Throwable)e1_ignored);
                }
                PluginId pluginId = IdeErrorsDialog.findPluginId(e);
                if (pluginId != null) {
                    throw new PluginException(e, pluginId);
                }
                LOG.info(e);
                IOException ioException = new IOException(e.getMessage());
                ioException.initCause(e);
                throw ioException;
            }
            saveSessionImpl = this.mySession = session;
        }
        catch (StateStorage.StateStorageException e) {
            LOG.info((Throwable)e);
            throw new IOException(e.getMessage());
        }
        if (saveSessionImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/ComponentStoreImpl.startSave must not return null");
        }
        return saveSessionImpl;
    }

    protected SaveSessionImpl createSaveSession() throws StateStorage.StateStorageException {
        return new SaveSessionImpl();
    }

    public void finishSave(@NotNull IComponentStore.SaveSession saveSession) {
        if (saveSession == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ComponentStoreImpl.finishSave must not be null");
        }
        assert (this.mySession == saveSession);
        this.mySession.finishSave();
        this.mySession = null;
    }

    private <T> void commitPersistentComponent(@NotNull PersistentStateComponent<T> persistentStateComponent, @NotNull StateStorageManager.ExternalizationSession session) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ComponentStoreImpl.commitPersistentComponent must not be null");
        }
        if (session == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ComponentStoreImpl.commitPersistentComponent must not be null");
        }
        Storage[] storageSpecs = this.getComponentStorageSpecs(persistentStateComponent, StateStorageOperation.WRITE);
        Object state = persistentStateComponent.getState();
        if (state != null) {
            session.setState(storageSpecs, persistentStateComponent, ComponentStoreImpl.getComponentName(persistentStateComponent), state);
        }
    }

    private static void commitJdomExternalizable(@NotNull JDOMExternalizable component, @NotNull StateStorageManager.ExternalizationSession session) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ComponentStoreImpl.commitJdomExternalizable must not be null");
        }
        if (session == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ComponentStoreImpl.commitJdomExternalizable must not be null");
        }
        String componentName = ComponentStoreImpl.getComponentName(component);
        session.setStateInOldStorage(component, componentName, component);
    }

    @Nullable
    String initJdomExternalizable(@NotNull JDOMExternalizable component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ComponentStoreImpl.initJdomExternalizable must not be null");
        }
        String componentName = ComponentStoreImpl.getComponentName(component);
        this.myComponents.put(componentName, component);
        if (this.optimizeTestLoading()) {
            return componentName;
        }
        this.loadJdomDefaults(component, componentName);
        Element element = null;
        StateStorage stateStorage = this.getOldStorage(component, componentName, StateStorageOperation.READ);
        if (stateStorage == null) {
            return null;
        }
        element = ComponentStoreImpl.getJdomState(component, componentName, stateStorage);
        if (element == null) {
            return null;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading configuration for " + component.getClass());
            }
            component.readExternal(element);
        }
        catch (InvalidDataException e) {
            throw new InvalidComponentDataException(e);
        }
        this.validateUnusedMacros(componentName, true);
        return componentName;
    }

    private static String getComponentName(@NotNull JDOMExternalizable component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ComponentStoreImpl.getComponentName must not be null");
        }
        if (component instanceof BaseComponent) {
            return ((BaseComponent)component).getComponentName();
        }
        return component.getClass().getName();
    }

    private void loadJdomDefaults(@NotNull Object component, String componentName) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ComponentStoreImpl.loadJdomDefaults must not be null");
        }
        try {
            StateStorage defaultsStorage = this.getDefaultsStorage();
            if (defaultsStorage == null) {
                return;
            }
            Element defaultState = ComponentStoreImpl.getJdomState(component, componentName, defaultsStorage);
            if (defaultState == null) {
                return;
            }
            ((JDOMExternalizable)component).readExternal(defaultState);
        }
        catch (Exception e) {
            LOG.error("Cannot load defaults for " + component.getClass(), (Throwable)e);
        }
    }

    @Nullable
    private static Element getJdomState(Object component, String componentName, @NotNull StateStorage defaultsStorage) throws StateStorage.StateStorageException {
        if (defaultsStorage == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ComponentStoreImpl.getJdomState must not be null");
        }
        ComponentRoamingManager roamingManager = ComponentRoamingManager.getInstance();
        if (!roamingManager.typeSpecified(componentName)) {
            if (component instanceof RoamingTypeDisabled) {
                roamingManager.setRoamingType(componentName, RoamingType.DISABLED);
            } else if (component instanceof RoamingTypePerPlatform) {
                roamingManager.setRoamingType(componentName, RoamingType.PER_PLATFORM);
            }
        }
        return (Element)defaultsStorage.getState(component, componentName, Element.class, null);
    }

    @Nullable
    protected Project getProject() {
        return null;
    }

    private void validateUnusedMacros(@Nullable String componentName, boolean service) {
        TrackingPathMacroSubstitutor substitutor;
        Project project = this.getProject();
        if (project == null) {
            return;
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode() && service && componentName != null && project.isInitialized() && (substitutor = this.getStateStorageManager().getMacroSubstitutor()) != null) {
            StorageUtil.notifyUnknownMacros(substitutor, project, componentName);
        }
    }

    private <T> String initPersistentComponent(@NotNull PersistentStateComponent<T> component, boolean reloadData) {
        Storage[] storageSpecs;
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ComponentStoreImpl.initPersistentComponent must not be null");
        }
        String name = ComponentStoreImpl.getComponentName(component);
        RoamingType roamingTypeFromComponent = ComponentStoreImpl.getRoamingType(component);
        ComponentRoamingManager roamingManager = ComponentRoamingManager.getInstance();
        if (!roamingManager.typeSpecified(name)) {
            roamingManager.setRoamingType(name, roamingTypeFromComponent);
        }
        this.myComponents.put(name, component);
        if (this.optimizeTestLoading()) {
            return name;
        }
        Class<T> stateClass = ComponentStoreImpl.getComponentStateClass(component);
        Object state = null;
        StateStorage defaultsStorage = this.getDefaultsStorage();
        if (defaultsStorage != null) {
            state = defaultsStorage.getState(component, name, stateClass, null);
        }
        for (Storage storageSpec : storageSpecs = this.getComponentStorageSpecs(component, StateStorageOperation.READ)) {
            StateStorage stateStorage = this.getStateStorage(storageSpec);
            if (stateStorage == null || !stateStorage.hasState(component, name, stateClass, reloadData)) continue;
            state = stateStorage.getState(component, name, stateClass, state);
        }
        if (state != null) {
            component.loadState(state);
        }
        this.validateUnusedMacros(name, true);
        return name;
    }

    private static RoamingType getRoamingType(PersistentStateComponent component) {
        if (component instanceof RoamingTypeDisabled) {
            return RoamingType.DISABLED;
        }
        if (component instanceof RoamingTypePerPlatform) {
            return RoamingType.PER_PLATFORM;
        }
        State stateSpec = ComponentStoreImpl.getStateSpec(component);
        assert (stateSpec != null);
        return stateSpec.roamingType();
    }

    @NotNull
    private static <T> Class<T> getComponentStateClass(@NotNull PersistentStateComponent<T> persistentStateComponent) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ComponentStoreImpl.getComponentStateClass must not be null");
        }
        Class<PersistentStateComponent> persistentStateComponentClass = PersistentStateComponent.class;
        Class<?> componentClass = persistentStateComponent.getClass();
        block0: while (true) {
            Class[] interfaces;
            for (Class anInterface : interfaces = ReflectionCache.getInterfaces(componentClass)) {
                if (anInterface.equals(persistentStateComponentClass)) break block0;
            }
            componentClass = componentClass.getSuperclass();
        }
        Type type = ReflectionUtil.resolveVariable(persistentStateComponentClass.getTypeParameters()[0], componentClass);
        Class clazz = ReflectionUtil.getRawType((Type)type);
        if (clazz == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/ComponentStoreImpl.getComponentStateClass must not return null");
        }
        return clazz;
    }

    private static String getComponentName(@NotNull PersistentStateComponent<?> persistentStateComponent) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ComponentStoreImpl.getComponentName must not be null");
        }
        State stateSpec = ComponentStoreImpl.getStateSpec(persistentStateComponent);
        if (stateSpec == null) {
            LOG.error("Null state spec for " + persistentStateComponent);
        }
        return stateSpec.name();
    }

    private static <T> State getStateSpec(@NotNull PersistentStateComponent<T> persistentStateComponent) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ComponentStoreImpl.getStateSpec must not be null");
        }
        Class<?> aClass = persistentStateComponent.getClass();
        State stateSpec = aClass.getAnnotation(State.class);
        if (stateSpec == null) {
            PluginId pluginId = PluginManager.getPluginByClassName((String)aClass.getName());
            if (pluginId != null) {
                throw new PluginException("No @State annotation found in " + aClass, pluginId);
            }
            throw new RuntimeException("No @State annotation found in " + aClass);
        }
        return stateSpec;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected <T> Storage[] getComponentStorageSpecs(@NotNull PersistentStateComponent<T> persistentStateComponent, StateStorageOperation operation) throws StateStorage.StateStorageException {
        Storage[] storageArray;
        Storage[] storageArray2;
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ComponentStoreImpl.getComponentStorageSpecs must not be null");
        }
        State stateSpec = ComponentStoreImpl.getStateSpec(persistentStateComponent);
        Storage[] storages = stateSpec.storages();
        if (storages.length == 1) {
            storageArray2 = storages;
            if (storages == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/ComponentStoreImpl.getComponentStorageSpecs must not return null");
            return storageArray2;
        }
        assert (storages.length > 0);
        Class<StorageAnnotationsDefaultValues.NullStateStorageChooser> defaultClass = StorageAnnotationsDefaultValues.NullStateStorageChooser.class;
        Class storageChooserClass = stateSpec.storageChooser();
        StateStorageChooser defaultStateStorageChooser = this.getDefaultStateStorageChooser();
        assert (storageChooserClass != defaultClass || defaultStateStorageChooser != null) : "State chooser not specified for: " + persistentStateComponent.getClass();
        if (storageChooserClass == defaultClass) {
            storageArray2 = defaultStateStorageChooser.selectStorages(storages, persistentStateComponent, operation);
            if (storageArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/ComponentStoreImpl.getComponentStorageSpecs must not return null");
            return storageArray2;
        }
        try {
            StateStorageChooser storageChooser = (StateStorageChooser)storageChooserClass.newInstance();
            storageArray = storageChooser.selectStorages(storages, persistentStateComponent, operation);
        }
        catch (InstantiationException e) {
            throw new StateStorage.StateStorageException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new StateStorage.StateStorageException((Throwable)e);
        }
        storageArray2 = storageArray;
        if (storageArray != null) return storageArray2;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/ComponentStoreImpl.getComponentStorageSpecs must not return null");
    }

    protected boolean optimizeTestLoading() {
        return false;
    }

    @Nullable
    protected StateStorageChooser getDefaultStateStorageChooser() {
        return null;
    }

    @Override
    public boolean isReloadPossible(Set<String> componentNames) {
        for (String componentName : componentNames) {
            Object component = this.myComponents.get(componentName);
            if (component == null) continue;
            if (!(component instanceof PersistentStateComponent)) {
                return false;
            }
            State stateSpec = ComponentStoreImpl.getStateSpec((PersistentStateComponent)component);
            if (stateSpec != null && stateSpec.reloadable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reinitComponents(Set<String> componentNames, boolean reloadData) {
        for (String componentName : componentNames) {
            PersistentStateComponent component = (PersistentStateComponent)this.myComponents.get(componentName);
            if (component == null) continue;
            this.initPersistentComponent(component, reloadData);
        }
    }

    protected void doReload(Set<Pair<VirtualFile, StateStorage>> changedFiles, @NotNull Set<String> componentNames) throws StateStorage.StateStorageException {
        if (componentNames == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ComponentStoreImpl.doReload must not be null");
        }
        for (Pair<VirtualFile, StateStorage> pair : changedFiles) {
            assert (pair != null);
            StateStorage storage = (StateStorage)pair.second;
            assert (storage != null) : "Null storage for: " + pair.first;
            storage.reload(componentNames);
        }
    }

    protected class SaveSessionImpl
    implements IComponentStore.SaveSession {
        protected StateStorageManager.SaveSession myStorageManagerSaveSession;

        public SaveSessionImpl() {
            ShutDownTracker.getInstance().registerStopperThread(Thread.currentThread());
        }

        @Override
        public List<IFile> getAllStorageFilesToSave(boolean includingSubStructures) throws IOException {
            try {
                return this.myStorageManagerSaveSession.getAllStorageFilesToSave();
            }
            catch (StateStorage.StateStorageException e) {
                throw new IOException(e.getMessage());
            }
        }

        @Override
        public IComponentStore.SaveSession save() throws IOException {
            try {
                SettingsSavingComponent[] settingsComponents;
                for (SettingsSavingComponent settingsSavingComponent : settingsComponents = ComponentStoreImpl.this.mySettingsSavingComponents.toArray(new SettingsSavingComponent[ComponentStoreImpl.this.mySettingsSavingComponents.size()])) {
                    try {
                        settingsSavingComponent.save();
                    }
                    catch (StateStorage.StateStorageException e) {
                        LOG.info((Throwable)e);
                        throw new IOException(e.getMessage());
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
                this.myStorageManagerSaveSession.save();
            }
            catch (StateStorage.StateStorageException e) {
                LOG.info((Throwable)e);
                throw new IOException(e.getMessage());
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishSave() {
            try {
                ComponentStoreImpl.this.getStateStorageManager().finishSave(this.myStorageManagerSaveSession);
                this.myStorageManagerSaveSession = null;
            }
            finally {
                ShutDownTracker.getInstance().unregisterStopperThread(Thread.currentThread());
                ComponentStoreImpl.this.mySession = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() {
            try {
                ComponentStoreImpl.this.getStateStorageManager().reset();
                this.myStorageManagerSaveSession = null;
            }
            finally {
                ShutDownTracker.getInstance().unregisterStopperThread(Thread.currentThread());
                ComponentStoreImpl.this.mySession = null;
            }
        }

        protected void commit() throws StateStorage.StateStorageException {
            String[] names;
            StateStorageManager storageManager = ComponentStoreImpl.this.getStateStorageManager();
            StateStorageManager.ExternalizationSession session = storageManager.startExternalization();
            for (String name : names = ArrayUtil.toStringArray(ComponentStoreImpl.this.myComponents.keySet())) {
                Object component = ComponentStoreImpl.this.myComponents.get(name);
                if (component instanceof PersistentStateComponent) {
                    ComponentStoreImpl.this.commitPersistentComponent((PersistentStateComponent)component, session);
                    continue;
                }
                if (!(component instanceof JDOMExternalizable)) continue;
                ComponentStoreImpl.commitJdomExternalizable((JDOMExternalizable)component, session);
            }
            this.myStorageManagerSaveSession = storageManager.startSave(session);
        }

        @Override
        @Nullable
        public Set<String> analyzeExternalChanges(Set<Pair<VirtualFile, StateStorage>> changedFiles) {
            return this.myStorageManagerSaveSession.analyzeExternalChanges(changedFiles);
        }

        @Override
        public List<IFile> getAllStorageFiles(boolean includingSubStructures) {
            return this.myStorageManagerSaveSession.getAllStorageFiles();
        }
    }
}

