/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.components.impl.BasePathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ModulePathMacroManager
extends BasePathMacroManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.ModulePathMacroManager");
    private final Module myModule;

    public ModulePathMacroManager(Module module) {
        this.myModule = module;
    }

    @Override
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result = new ExpandMacroToPathMap();
        this.getExpandModuleHomeReplacements(result);
        result.putAll(super.getExpandMacroMap());
        return result;
    }

    @Override
    public ReplacePathToMacroMap getReplacePathMap() {
        ReplacePathToMacroMap result = new ReplacePathToMacroMap();
        result.putAll(super.getReplacePathMap());
        this.getModuleHomeReplacements(result, true);
        return result;
    }

    private void getExpandModuleHomeReplacements(ExpandMacroToPathMap result) {
        String moduleDir;
        String string = moduleDir = this.myModule.isDisposed() ? null : this.getModuleDir(this.myModule.getModuleFilePath());
        if (moduleDir == null) {
            return;
        }
        File f = new File(moduleDir.replace('/', File.separatorChar));
        ModulePathMacroManager.getExpandModuleHomeReplacements(result, f, "$MODULE_DIR$");
    }

    private static void getExpandModuleHomeReplacements(ExpandMacroToPathMap result, File f, String macro) {
        if (f == null) {
            return;
        }
        ModulePathMacroManager.getExpandModuleHomeReplacements(result, f.getParentFile(), macro + "/..");
        String path = PathMacroMap.quotePath(f.getAbsolutePath());
        String s = macro;
        if (StringUtil.endsWithChar((CharSequence)path, (char)'/')) {
            s = s + "/";
        }
        result.put(s, path);
    }

    private void getModuleHomeReplacements(@NonNls ReplacePathToMacroMap result, boolean addRelativePathMacros) {
        String moduleDir;
        String string = moduleDir = this.myModule.isDisposed() ? null : this.getModuleDir(this.myModule.getModuleFilePath());
        if (moduleDir == null) {
            return;
        }
        String macro = "$MODULE_DIR$";
        boolean check = false;
        for (File f = new File(moduleDir.replace('/', File.separatorChar)); f != null && f.getParentFile() != null; f = f.getParentFile()) {
            String path = PathMacroMap.quotePath(f.getAbsolutePath());
            String s = macro;
            if (StringUtil.endsWithChar((CharSequence)path, (char)'/')) {
                s = s + "/";
            }
            ModulePathMacroManager.putIfAbsent(result, "file://" + path, "file://" + s, check);
            ModulePathMacroManager.putIfAbsent(result, "file:/" + path, "file:/" + s, check);
            ModulePathMacroManager.putIfAbsent(result, "file:" + path, "file:" + s, check);
            ModulePathMacroManager.putIfAbsent(result, "jar://" + path, "jar://" + s, check);
            ModulePathMacroManager.putIfAbsent(result, "jar:/" + path, "jar:/" + s, check);
            ModulePathMacroManager.putIfAbsent(result, "jar:" + path, "jar:" + s, check);
            if (!(path.equalsIgnoreCase("e:/") || path.equalsIgnoreCase("r:/") || path.equalsIgnoreCase("p:/"))) {
                ModulePathMacroManager.putIfAbsent(result, path, s, check);
            }
            if (!addRelativePathMacros) break;
            macro = macro + "/..";
            check = true;
        }
    }

    @Nullable
    private String getModuleDir(String moduleFilePath) {
        File moduleDirParent;
        File moduleDirFile = new File(moduleFilePath).getParentFile();
        if (moduleDirFile == null) {
            return null;
        }
        VirtualFile baseDir = this.myModule.getProject().getBaseDir();
        if (baseDir != null && (moduleDirParent = moduleDirFile.getParentFile()) != null && moduleDirFile.getName().equals(".idea") && moduleDirParent.getPath().equals(FileUtil.toSystemDependentName((String)baseDir.getPath()))) {
            moduleDirFile = moduleDirParent;
        }
        String moduleDir = moduleDirFile.getPath();
        if ((moduleDir = moduleDir.replace(File.separatorChar, '/')).endsWith(":/")) {
            moduleDir = moduleDir.substring(0, moduleDir.length() - 1);
        }
        return moduleDir;
    }
}

