/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.impl.ComponentManagerImpl;

class ComponentManagerConfigurator {
    private final ComponentManagerImpl myComponentManager;

    public ComponentManagerConfigurator(ComponentManagerImpl componentManager) {
        this.myComponentManager = componentManager;
    }

    private void loadConfiguration(ComponentConfig[] configs, boolean defaultProject, IdeaPluginDescriptor descriptor) {
        for (ComponentConfig config : configs) {
            this.loadSingleConfig(defaultProject, config, descriptor);
        }
    }

    private void loadSingleConfig(boolean defaultProject, ComponentConfig config, IdeaPluginDescriptor descriptor) {
        if (defaultProject && config.skipForDefaultProject) {
            return;
        }
        if (!this.myComponentManager.isComponentSuitable(config.options)) {
            return;
        }
        this.myComponentManager.registerComponent(config, descriptor);
    }

    public void loadComponentsConfiguration(ComponentConfig[] components, IdeaPluginDescriptor descriptor, boolean defaultProject) {
        if (components == null) {
            return;
        }
        this.loadConfiguration(components, defaultProject, descriptor);
    }
}

