/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.FactoryMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class BasePathMacroManager
extends PathMacroManager {
    private PathMacrosImpl myPathMacros;
    private boolean myUseUserMacroses;

    public BasePathMacroManager(boolean useUserMacroses) {
        this.myUseUserMacroses = useUserMacroses;
    }

    public BasePathMacroManager() {
        this(true);
    }

    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result = new ExpandMacroToPathMap();
        result.addMacroExpand("APPLICATION_HOME_DIR", PathManager.getHomePath());
        if (this.myUseUserMacroses) {
            this.getPathMacros().addMacroExpands(result);
        }
        return result;
    }

    @Override
    public ReplacePathToMacroMap getReplacePathMap() {
        ReplacePathToMacroMap result = new ReplacePathToMacroMap();
        result.addMacroReplacement(PathManager.getHomePath(), "APPLICATION_HOME_DIR");
        if (this.myUseUserMacroses) {
            this.getPathMacros().addMacroReplacements(result);
        }
        return result;
    }

    @Override
    public TrackingPathMacroSubstitutor createTrackingSubstitutor() {
        return new MyTrackingPathMacroSubstitutor();
    }

    @Override
    public String expandPath(String path) {
        return this.getExpandMacroMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public String collapsePath(String path) {
        return this.getReplacePathMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void collapsePathsRecursively(Element element) {
        this.getReplacePathMap().substitute(element, SystemInfo.isFileSystemCaseSensitive, true);
    }

    @Override
    public void expandPaths(Element element) {
        this.getExpandMacroMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void collapsePaths(Element element) {
        this.getReplacePathMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
    }

    public PathMacrosImpl getPathMacros() {
        if (this.myPathMacros == null) {
            this.myPathMacros = PathMacrosImpl.getInstanceEx();
        }
        return this.myPathMacros;
    }

    protected static void putIfAbsent(ReplacePathToMacroMap result, @NonNls String pathWithPrefix, @NonNls String substWithPrefix, boolean check) {
        if (check && result.get(pathWithPrefix) != null) {
            return;
        }
        result.put(pathWithPrefix, substWithPrefix);
    }

    private class MyTrackingPathMacroSubstitutor
    implements TrackingPathMacroSubstitutor {
        private final Map<String, Set<String>> myMacroToComponentNames = new FactoryMap<String, Set<String>>(){

            protected Set<String> create(String key) {
                return new HashSet<String>();
            }
        };
        private final Map<String, Set<String>> myComponentNameToMacros = new FactoryMap<String, Set<String>>(){

            protected Set<String> create(String key) {
                return new HashSet<String>();
            }
        };

        @Override
        public void reset() {
            this.myMacroToComponentNames.clear();
            this.myComponentNameToMacros.clear();
        }

        @Override
        public String expandPath(String path) {
            return BasePathMacroManager.this.getExpandMacroMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
        }

        @Override
        public String collapsePath(String path) {
            return BasePathMacroManager.this.getReplacePathMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
        }

        @Override
        public void expandPaths(Element element) {
            BasePathMacroManager.this.getExpandMacroMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
        }

        @Override
        public void collapsePaths(Element element) {
            BasePathMacroManager.this.getReplacePathMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
        }

        public int hashCode() {
            return BasePathMacroManager.this.getExpandMacroMap().hashCode();
        }

        @Override
        public void invalidateUnknownMacros(Set<String> macros) {
            for (String macro : macros) {
                Set<String> components = this.myMacroToComponentNames.get(macro);
                for (String component : components) {
                    this.myComponentNameToMacros.remove(component);
                }
                this.myMacroToComponentNames.remove(macro);
            }
        }

        @Override
        public Collection<String> getComponents(Collection<String> macros) {
            HashSet<String> result = new HashSet<String>();
            for (String macro : this.myMacroToComponentNames.keySet()) {
                if (!macros.contains(macro)) continue;
                result.addAll((Collection<String>)this.myMacroToComponentNames.get(macro));
            }
            return result;
        }

        @Override
        public Collection<String> getUnknownMacros(String componentName) {
            HashSet<String> result = new HashSet<String>();
            result.addAll(componentName == null ? this.myMacroToComponentNames.keySet() : this.myComponentNameToMacros.get(componentName));
            return Collections.unmodifiableCollection(result);
        }

        @Override
        public void addUnknownMacros(String componentName, Collection<String> unknownMacros) {
            if (unknownMacros.isEmpty()) {
                return;
            }
            for (String unknownMacro : unknownMacros) {
                Set<String> stringList = this.myMacroToComponentNames.get(unknownMacro);
                stringList.add(componentName);
            }
            this.myComponentNameToMacros.get(componentName).addAll(unknownMacros);
        }
    }
}

