/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentReferenceByVirtualFile
implements DocumentReference {
    private VirtualFile myFile;

    DocumentReferenceByVirtualFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/command/impl/DocumentReferenceByVirtualFile.<init> must not be null");
        }
        this.myFile = file;
    }

    @Nullable
    public Document getDocument() {
        assert (this.myFile.isValid()) : "should not be called on references to deleted file: " + this.myFile;
        return FileDocumentManager.getInstance().getDocument(this.myFile);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/command/impl/DocumentReferenceByVirtualFile.getFile must not return null");
        }
        return virtualFile;
    }

    public String toString() {
        return this.myFile.toString();
    }

    public void update(VirtualFile f) {
        this.myFile = f;
    }
}

