/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.Notifications;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ProjectNotificationsComponent
implements Notifications,
ProjectComponent {
    private Project myProject;

    public ProjectNotificationsComponent(Project project) {
        this.myProject = project;
    }

    public void projectOpened() {
        if (ProjectNotificationsComponent.isDummyEnvironment()) {
            return;
        }
        this.myProject.getMessageBus().connect().subscribe(TOPIC, (Object)this);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                NotificationsManagerImpl.getNotificationsManagerImpl().clear(ProjectNotificationsComponent.this.myProject);
            }
        });
    }

    public void notify(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ProjectNotificationsComponent.notify must not be null");
        }
        NotificationsManagerImpl.getNotificationsManagerImpl().doNotify(notification, null, this.myProject);
    }

    public void notify(@NotNull Notification notification, @NotNull NotificationDisplayType defaultDisplayType) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ProjectNotificationsComponent.notify must not be null");
        }
        if (defaultDisplayType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/notification/impl/ProjectNotificationsComponent.notify must not be null");
        }
        NotificationsManagerImpl.getNotificationsManagerImpl().doNotify(notification, defaultDisplayType, this.myProject);
    }

    public void projectClosed() {
        Collection<Notification> collection = NotificationsManagerImpl.getNotificationsManagerImpl().getByType(null, this.myProject);
        for (Notification notification : collection) {
            Balloon balloon = notification.getBalloon();
            if (balloon == null) continue;
            balloon.hide();
        }
    }

    private static boolean isDummyEnvironment() {
        Application application = ApplicationManager.getApplication();
        return application.isUnitTestMode() || application.isCommandLine();
    }

    @NotNull
    public String getComponentName() {
        if ("Project Notifications" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/notification/impl/ProjectNotificationsComponent.getComponentName must not return null");
        }
        return "Project Notifications";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.myProject = null;
    }
}

