/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lifecycle;

import com.intellij.lifecycle.AtomicSectionsAware;
import com.intellij.lifecycle.ControlledAlarmFactory;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlowlyClosingAlarm
implements AtomicSectionsAware,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lifecycle.SlowlyClosingAlarm");
    protected final ControlledAlarmFactory.MyExecutorWrapper myExecutorService;
    private boolean myInUninterruptibleState;
    protected boolean myDisposeStarted;
    private boolean myFinished;
    protected final List<Future<?>> myFutureList;
    protected final Object myLock;
    private static final ThreadFactory THREAD_FACTORY_OWN = SlowlyClosingAlarm.threadFactory("SlowlyClosingAlarm pool");
    private final String myName;
    private final boolean myExecutorIsShared;
    private boolean myDisposed;

    private static ThreadFactory threadFactory(final @NonNls String threadsName) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, threadsName);
                thread.setPriority(1);
                return thread;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            this.safelyShutdownExecutor();
            for (Future<?> future : this.myFutureList) {
                future.cancel(true);
            }
            this.myFutureList.clear();
            this.myDisposed = true;
        }
    }

    protected SlowlyClosingAlarm(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lifecycle/SlowlyClosingAlarm.<init> must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lifecycle/SlowlyClosingAlarm.<init> must not be null");
        }
        this(project, name, ControlledAlarmFactory.createExecutorWrapper(Executors.newSingleThreadExecutor(THREAD_FACTORY_OWN)), false);
    }

    protected SlowlyClosingAlarm(@NotNull Project project, @NotNull String name, ControlledAlarmFactory.MyExecutorWrapper executor, boolean executorIsShared) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lifecycle/SlowlyClosingAlarm.<init> must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lifecycle/SlowlyClosingAlarm.<init> must not be null");
        }
        this.myName = name;
        this.myExecutorIsShared = executorIsShared;
        this.myExecutorService = executor;
        this.myLock = new Object();
        this.myFutureList = new ArrayList();
        Disposer.register((Disposable)project, (Disposable)this);
        this.myDisposeStarted = !PeriodicalTasksCloser.getInstance(project).register(name, new Runnable(){

            @Override
            public void run() {
                SlowlyClosingAlarm.this.waitAndInterrupt(ProgressManager.getInstance().getProgressIndicator());
            }
        });
    }

    protected void debug(String s) {
        LOG.debug(this.myName + " " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(Runnable runnable) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDisposed || this.myDisposeStarted) {
                return;
            }
            MyWrapper wrapper = new MyWrapper(runnable);
            Future<?> future = this.myExecutorService.submit(wrapper);
            wrapper.setFuture(future);
            this.myFutureList.add(future);
            this.debug("request added");
        }
    }

    private void stopSelf() {
        if (this.myExecutorIsShared) {
            throw new ProcessCanceledException();
        }
        Thread.currentThread().interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enter() {
        Object object = this.myLock;
        synchronized (object) {
            this.debug("entering section");
            if (this.myDisposeStarted) {
                this.debug("self-interrupting (1)");
                this.stopSelf();
            }
            this.myInUninterruptibleState = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exit() {
        this.debug("exiting section");
        Object object = this.myLock;
        synchronized (object) {
            this.myInUninterruptibleState = false;
            if (this.myDisposeStarted) {
                this.debug("self-interrupting (2)");
                this.stopSelf();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldExitAsap() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myDisposeStarted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkShouldExit() throws ProcessCanceledException {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDisposeStarted) {
                this.stopSelf();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safelyShutdownExecutor() {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myExecutorIsShared) {
                try {
                    this.myExecutorService.shutdown();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAndInterrupt(@Nullable ProgressIndicator indicator) {
        ArrayList copy;
        Object object = this.myLock;
        synchronized (object) {
            this.debug("starting shutdown: " + this.myFutureList.size());
            this.myDisposeStarted = true;
            this.safelyShutdownExecutor();
            copy = new ArrayList(this.myFutureList.size());
            for (Future<Object> future : this.myFutureList) {
                if (future.isDone()) continue;
                copy.add(future);
            }
        }
        this.debug("waiting for gets");
        boolean wasCanceled = false;
        block12: for (Future<Object> future : copy) {
            if (wasCanceled) break;
            while (true) {
                try {
                    if (indicator == null) {
                        future.get();
                        continue block12;
                    }
                    future.get(500L, TimeUnit.MILLISECONDS);
                    continue block12;
                }
                catch (CancellationException e) {
                    continue block12;
                }
                catch (InterruptedException e) {
                    continue block12;
                }
                catch (ExecutionException e) {
                    continue block12;
                }
                catch (TimeoutException e) {
                    if (indicator == null) continue;
                    if (wasCanceled |= indicator.isCanceled()) continue block12;
                    this.debug("was canceled");
                    continue;
                }
                break;
            }
        }
        this.debug("finishing " + this.myInUninterruptibleState);
        Object object2 = this.myLock;
        synchronized (object2) {
            for (Future<?> future : this.myFutureList) {
                future.cancel(true);
            }
            this.myFutureList.clear();
            this.myFinished = true;
        }
        this.debug("done");
    }

    protected class MyWrapper
    implements Runnable {
        private final Runnable myDelegate;
        private Future myFuture;

        protected MyWrapper(Runnable delegate) {
            this.myDelegate = delegate;
        }

        public void setFuture(Future future) {
            this.myFuture = future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SlowlyClosingAlarm.this.debug("wrapper starts runnable");
                this.myDelegate.run();
                SlowlyClosingAlarm.this.debug("wrapper: runnable succesfully finished");
            }
            finally {
                if (this.myFuture != null) {
                    SlowlyClosingAlarm.this.debug("removing future");
                    Object object = SlowlyClosingAlarm.this.myLock;
                    synchronized (object) {
                        SlowlyClosingAlarm.this.myFutureList.remove(this.myFuture);
                    }
                }
            }
        }
    }
}

