/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.BaseHtmlLexer;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.lexer._HtmlLexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;

public class HtmlLexer
extends BaseHtmlLexer {
    private static IElementType ourStyleElementType;
    private static IElementType ourInlineStyleElementType;
    private static IElementType ourScriptElementType;
    private static IElementType ourInlineScriptElementType;
    private IElementType myTokenType;
    private int myTokenStart;
    private int myTokenEnd;

    @Override
    public void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myTokenType = null;
        super.start(buffer, startOffset, endOffset, initialState);
    }

    @Override
    public void advance() {
        this.myTokenType = null;
        super.advance();
    }

    public IElementType getTokenType() {
        if (this.myTokenType != null) {
            return this.myTokenType;
        }
        IElementType tokenType = super.getTokenType();
        this.myTokenStart = super.getTokenStart();
        this.myTokenEnd = super.getTokenEnd();
        if (this.hasSeenStyle()) {
            if (this.hasSeenTag() && ourStyleElementType != null && HtmlLexer.isStartOfEmbeddmentTagContent(tokenType)) {
                this.myTokenEnd = this.skipToTheEndOfTheEmbeddment();
                tokenType = ourStyleElementType;
            } else if (ourInlineStyleElementType != null && HtmlLexer.isStartOfEmbeddmentAttributeValue(tokenType) && this.hasSeenAttribute()) {
                tokenType = ourInlineStyleElementType;
            }
        } else if (this.hasSeenScript()) {
            if (this.hasSeenTag() && ourScriptElementType != null && HtmlLexer.isStartOfEmbeddmentTagContent(tokenType)) {
                this.myTokenEnd = this.skipToTheEndOfTheEmbeddment();
                tokenType = ourScriptElementType;
            } else if (this.hasSeenAttribute() && HtmlLexer.isStartOfEmbeddmentAttributeValue(tokenType) && ourInlineScriptElementType != null) {
                this.myTokenEnd = this.skipToTheEndOfTheEmbeddment();
                tokenType = ourInlineScriptElementType;
            }
        }
        this.myTokenType = tokenType;
        return this.myTokenType;
    }

    private static boolean isStartOfEmbeddmentAttributeValue(IElementType tokenType) {
        return tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
    }

    private static boolean isStartOfEmbeddmentTagContent(IElementType tokenType) {
        return tokenType == XmlTokenType.XML_DATA_CHARACTERS || tokenType == XmlTokenType.XML_CDATA_START || tokenType == XmlTokenType.XML_COMMENT_START || tokenType == XmlTokenType.XML_REAL_WHITE_SPACE || tokenType == TokenType.WHITE_SPACE;
    }

    public HtmlLexer() {
        this((Lexer)new MergingLexerAdapter((Lexer)new FlexAdapter((FlexLexer)new _HtmlLexer()), TOKENS_TO_MERGE), true);
    }

    protected HtmlLexer(Lexer _baseLexer, boolean _caseInsensitive) {
        super(_baseLexer, _caseInsensitive);
    }

    public static void setStyleElementTypes(IElementType _styleElementType, IElementType _inlineStyleElementType) {
        ourStyleElementType = _styleElementType;
        ourInlineStyleElementType = _inlineStyleElementType;
    }

    @Override
    protected boolean isHtmlTagState(int state) {
        return state == 3 || state == 4;
    }

    public int getTokenStart() {
        if (this.myTokenType != null) {
            return this.myTokenStart;
        }
        return super.getTokenStart();
    }

    public int getTokenEnd() {
        if (this.myTokenType != null) {
            return this.myTokenEnd;
        }
        return super.getTokenEnd();
    }

    public static void setScriptElementTypes(IElementType scriptElementType, IElementType inlineScriptElementType) {
        ourScriptElementType = scriptElementType;
        ourInlineScriptElementType = inlineScriptElementType;
    }
}

