/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.application.options.editor.XmlFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlConditionalSection;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.xml.util.XmlTagUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XmlFoldingBuilder
implements FoldingBuilder,
DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.xml.XmlFoldingBuilder");
    private static final TokenSet XML_ATTRIBUTE_SET = TokenSet.create((IElementType[])new IElementType[]{XmlElementType.XML_ATTRIBUTE});

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        XmlTag rootTag;
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/xml/XmlFoldingBuilder.buildFoldRegions must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/xml/XmlFoldingBuilder.buildFoldRegions must not be null");
        }
        PsiElement psiElement = node.getPsi();
        XmlDocument xmlDocument = null;
        if (psiElement instanceof XmlFile) {
            XmlFile file = (XmlFile)psiElement;
            xmlDocument = file.getDocument();
        } else if (psiElement instanceof XmlDocument) {
            xmlDocument = (XmlDocument)psiElement;
        }
        XmlTag xmlTag = rootTag = xmlDocument == null ? null : xmlDocument.getRootTag();
        if (rootTag == null) {
            rootTag = xmlDocument;
        }
        ArrayList<FoldingDescriptor> foldings = null;
        if (rootTag != null) {
            foldings = new ArrayList<FoldingDescriptor>();
            if (rootTag instanceof XmlTag) {
                this.addElementsToFold(foldings, (XmlElement)rootTag, document);
                for (PsiElement sibling = rootTag.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                    if (!(sibling instanceof XmlTag)) continue;
                    this.addElementsToFold(foldings, (XmlElement)sibling, document);
                }
            } else {
                this.doAddForChildren((XmlElement)xmlDocument, foldings, document);
            }
        }
        FoldingDescriptor[] foldingDescriptorArray = foldings != null ? foldings.toArray(new FoldingDescriptor[foldings.size()]) : FoldingDescriptor.EMPTY;
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFoldingBuilder.buildFoldRegions must not return null");
        }
        return foldingDescriptorArray;
    }

    protected void addElementsToFold(List<FoldingDescriptor> foldings, XmlElement tag, Document document) {
        if (this.addToFold(foldings, (PsiElement)tag, document)) {
            this.doAddForChildren(tag, foldings, document);
        }
    }

    protected void doAddForChildren(XmlElement tag, List<FoldingDescriptor> foldings, Document document) {
        PsiElement[] children;
        for (PsiElement child : children = tag.getChildren()) {
            FoldingBuilder foldingBuilder;
            ProgressManager.checkCanceled();
            if (child instanceof XmlTag || child instanceof XmlConditionalSection) {
                this.addElementsToFold(foldings, (XmlElement)child, document);
                continue;
            }
            if (child instanceof XmlComment) {
                this.addToFold(foldings, child, document);
                continue;
            }
            if (child instanceof XmlText) {
                PsiElement[] grandChildren;
                for (PsiElement grandChild : grandChildren = child.getChildren()) {
                    ProgressManager.checkCanceled();
                    if (!(grandChild instanceof XmlComment)) continue;
                    this.addToFold(foldings, grandChild, document);
                }
                continue;
            }
            Language language = child.getLanguage();
            if (language instanceof XMLLanguage || language == Language.ANY || (foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language)) == null) continue;
            FoldingDescriptor[] foldingDescriptors = foldingBuilder.buildFoldRegions(child.getNode(), document);
            foldings.addAll(Arrays.asList(foldingDescriptors));
        }
    }

    public TextRange getRangeToFold(PsiElement element) {
        if (element instanceof XmlTag) {
            ASTNode tagNode = element.getNode();
            XmlToken tagNameElement = XmlTagUtil.getStartTagNameElement((XmlTag)((XmlTag)element));
            if (tagNameElement == null) {
                return null;
            }
            int nameEnd = tagNameElement.getTextRange().getEndOffset();
            int end = tagNode.getLastChildNode().getTextRange().getEndOffset() - 1;
            ASTNode[] attributes = tagNode.getChildren(XML_ATTRIBUTE_SET);
            if (attributes.length > 0) {
                ASTNode lastAttribute = attributes[attributes.length - 1];
                ASTNode lastAttributeBeforeCR = null;
                for (ASTNode child = tagNode.getFirstChildNode(); child != lastAttribute.getTreeNext(); child = child.getTreeNext()) {
                    if (child.getElementType() == XmlElementType.XML_ATTRIBUTE) {
                        lastAttributeBeforeCR = child;
                        continue;
                    }
                    if (child.getPsi() instanceof PsiWhiteSpace && child.textContains('\n')) break;
                }
                if (lastAttributeBeforeCR != null) {
                    int attributeEnd = lastAttributeBeforeCR.getTextRange().getEndOffset();
                    return new TextRange(attributeEnd, end);
                }
            }
            return new TextRange(nameEnd, end);
        }
        if (element instanceof XmlComment) {
            XmlComment xmlComment = (XmlComment)element;
            TextRange textRange = element.getTextRange();
            int commentStartOffset = this.getCommentStartOffset(xmlComment);
            int commentEndOffset = this.getCommentStartEnd(xmlComment);
            if (textRange.getEndOffset() - textRange.getStartOffset() > commentStartOffset + commentEndOffset) {
                return new TextRange(textRange.getStartOffset() + commentStartOffset, textRange.getEndOffset() - commentEndOffset);
            }
            return null;
        }
        if (element instanceof XmlConditionalSection) {
            XmlConditionalSection conditionalSection = (XmlConditionalSection)element;
            TextRange textRange = element.getTextRange();
            PsiElement bodyStart = conditionalSection.getBodyStart();
            int startOffset = bodyStart != null ? bodyStart.getStartOffsetInParent() : 3;
            int endOffset = 3;
            if (textRange.getEndOffset() - textRange.getStartOffset() > startOffset + endOffset) {
                return new TextRange(textRange.getStartOffset() + startOffset, textRange.getEndOffset() - endOffset);
            }
            return null;
        }
        return null;
    }

    protected int getCommentStartOffset(XmlComment element) {
        return 4;
    }

    protected int getCommentStartEnd(XmlComment element) {
        return 3;
    }

    protected boolean addToFold(List<FoldingDescriptor> foldings, PsiElement elementToFold, Document document) {
        int endLine;
        int startLine;
        LOG.assertTrue(elementToFold.isValid());
        TextRange range = this.getRangeToFold(elementToFold);
        if (range == null) {
            return false;
        }
        if (range.getStartOffset() >= 0 && range.getEndOffset() <= elementToFold.getContainingFile().getTextRange().getEndOffset() && range.getEndOffset() <= document.getTextLength() && (startLine = document.getLineNumber(range.getStartOffset())) < (endLine = document.getLineNumber(range.getEndOffset() - 1))) {
            foldings.add(new FoldingDescriptor(elementToFold.getNode(), range));
            return true;
        }
        return false;
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/xml/XmlFoldingBuilder.getPlaceholderText must not be null");
        }
        PsiElement psi = node.getPsi();
        if (psi instanceof XmlTag || psi instanceof XmlComment || psi instanceof XmlConditionalSection) {
            return "...";
        }
        return null;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/xml/XmlFoldingBuilder.isCollapsedByDefault must not be null");
        }
        PsiElement psi = node.getPsi();
        return psi instanceof XmlTag && XmlFoldingSettings.getInstance().isCollapseXmlTags();
    }
}

