/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.PsiBasedFormatterModelWithShiftIndentInside;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFormattingModelBuilder
implements FormattingModelBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.java.JavaFormattingModelBuilder");

    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        FileElement fileElement = TreeUtil.getFileElement((TreeElement)SourceTreeToPsiMap.psiElementToTree(element));
        LOG.assertTrue(fileElement != null, (Object)("File element should not be null for " + element));
        Block block = AbstractJavaBlock.createJavaBlock(fileElement, settings);
        FormattingDocumentModelImpl model = FormattingDocumentModelImpl.createOn(element.getContainingFile());
        PsiBasedFormatterModelWithShiftIndentInside psiBasedFormatterModelWithShiftIndentInside = new PsiBasedFormatterModelWithShiftIndentInside(element.getContainingFile(), block, model);
        if (psiBasedFormatterModelWithShiftIndentInside == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaFormattingModelBuilder.createModel must not return null");
        }
        return psiBasedFormatterModelWithShiftIndentInside;
    }

    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        ASTNode current = elementAtOffset;
        if ((current = JavaFormattingModelBuilder.findNearestExpressionParent(current)) == null) {
            if (elementAtOffset.getElementType() == TokenType.WHITE_SPACE) {
                ASTNode prevElement = elementAtOffset.getTreePrev();
                if (prevElement == null) {
                    return elementAtOffset.getTextRange();
                }
                ASTNode prevExpressionParent = JavaFormattingModelBuilder.findNearestExpressionParent(prevElement);
                if (prevExpressionParent == null) {
                    return elementAtOffset.getTextRange();
                }
                return new TextRange(prevExpressionParent.getTextRange().getStartOffset(), elementAtOffset.getTextRange().getEndOffset());
            }
            return elementAtOffset.getTextRange();
        }
        return current.getTextRange();
    }

    @Nullable
    private static ASTNode findNearestExpressionParent(ASTNode current) {
        ASTNode result;
        for (result = current; result != null; result = result.getTreeParent()) {
            PsiElement psi = result.getPsi();
            if (!(psi instanceof PsiExpression) || psi.getParent() instanceof PsiExpression) continue;
            return result;
        }
        return result;
    }
}

