/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.html.HTMLParser;
import com.intellij.lexer.HtmlLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class HTMLParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(Project project) {
        HtmlLexer htmlLexer = new HtmlLexer();
        if (htmlLexer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/html/HTMLParserDefinition.createLexer must not return null");
        }
        return htmlLexer;
    }

    public IFileElementType getFileNodeType() {
        return XmlElementType.HTML_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = XmlTokenType.WHITESPACES;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/html/HTMLParserDefinition.getWhitespaceTokens must not return null");
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = XmlTokenType.COMMENTS;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/html/HTMLParserDefinition.getCommentTokens must not return null");
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/html/HTMLParserDefinition.getStringLiteralElements must not return null");
        }
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        HTMLParser hTMLParser = new HTMLParser();
        if (hTMLParser == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/html/HTMLParserDefinition.createParser must not return null");
        }
        return hTMLParser;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        PsiElement psiElement = PsiUtilBase.NULL_PSI_ELEMENT;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/html/HTMLParserDefinition.createElement must not return null");
        }
        return psiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new HtmlFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        Lexer lexer = this.createLexer(left.getPsi().getProject());
        return XmlUtil.canStickTokensTogetherByLexerInXml(left, right, lexer, 0);
    }
}

