/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageASTFactory;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.CodeFragmentElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.PsiCommentImpl;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.tree.ICompositeElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.ILeafElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ASTFactory {
    public static final DefaultFactory DEFAULT = new DefaultFactory();
    private static final CharTable WHITSPACES = new CharTableImpl();

    @Nullable
    public abstract CompositeElement createComposite(IElementType var1);

    @Nullable
    public LazyParseableElement createLazy(ILazyParseableElementType type, CharSequence text) {
        if (type instanceof IFileElementType) {
            return new FileElement((IElementType)type, text);
        }
        return new LazyParseableElement((IElementType)type, text);
    }

    @Nullable
    public abstract LeafElement createLeaf(IElementType var1, CharSequence var2);

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static LazyParseableElement lazy(ILazyParseableElementType type, CharSequence text) {
        LazyParseableElement lazyParseableElement;
        ASTNode node = type.createNode(text);
        if (node != null) {
            lazyParseableElement = (LazyParseableElement)node;
            if (lazyParseableElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.lazy must not return null");
            return lazyParseableElement;
        }
        if (type == TokenType.CODE_FRAGMENT) {
            lazyParseableElement = new CodeFragmentElement(null);
            if (lazyParseableElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.lazy must not return null");
            return lazyParseableElement;
        }
        LazyParseableElement psi = ASTFactory.factory((IElementType)type).createLazy(type, text);
        lazyParseableElement = psi != null ? psi : DEFAULT.createLazy(type, text);
        if (lazyParseableElement != null) return lazyParseableElement;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.lazy must not return null");
    }

    @Deprecated
    @NotNull
    public static LeafElement leaf(IElementType type, CharSequence fileText, int start, int end, CharTable table) {
        LeafElement leafElement = ASTFactory.leaf(type, table.intern(fileText, start, end));
        if (leafElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.leaf must not return null");
        }
        return leafElement;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static LeafElement leaf(IElementType type, CharSequence text) {
        LeafElement leafElement;
        if (type == TokenType.WHITE_SPACE) {
            leafElement = new PsiWhiteSpaceImpl(text);
            if (leafElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.leaf must not return null");
            return leafElement;
        }
        if (type instanceof ILeafElementType) {
            leafElement = (LeafElement)((ILeafElementType)type).createLeafNode(text);
            if (leafElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.leaf must not return null");
            return leafElement;
        }
        LeafElement customLeaf = ASTFactory.factory(type).createLeaf(type, text);
        leafElement = customLeaf != null ? customLeaf : DEFAULT.createLeaf(type, text);
        if (leafElement != null) return leafElement;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.leaf must not return null");
    }

    private static ASTFactory factory(IElementType type) {
        return (ASTFactory)LanguageASTFactory.INSTANCE.forLanguage(type.getLanguage());
    }

    public static LeafElement whitespace(CharSequence text) {
        PsiWhiteSpaceImpl w = new PsiWhiteSpaceImpl(WHITSPACES.intern(text));
        CodeEditUtil.setNodeGenerated(w, true);
        return w;
    }

    public static LeafElement leaf(IElementType type, CharSequence text, CharTable table) {
        return ASTFactory.leaf(type, table.intern(text));
    }

    public static LeafElement leaf(Lexer lexer, CharTable charTable) {
        return ASTFactory.leaf(lexer.getTokenType(), LexerUtil.internToken((Lexer)lexer, (CharTable)charTable));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static CompositeElement composite(IElementType type) {
        CompositeElement compositeElement;
        if (type instanceof ICompositeElementType) {
            compositeElement = (CompositeElement)((ICompositeElementType)type).createCompositeNode();
            if (compositeElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.composite must not return null");
            return compositeElement;
        }
        if (type == TokenType.CODE_FRAGMENT) {
            compositeElement = new CodeFragmentElement(null);
            if (compositeElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.composite must not return null");
            return compositeElement;
        }
        CompositeElement customComposite = ASTFactory.factory(type).createComposite(type);
        compositeElement = customComposite != null ? customComposite : DEFAULT.createComposite(type);
        if (compositeElement != null) return compositeElement;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.composite must not return null");
    }

    private static class DefaultFactory
    extends ASTFactory {
        private DefaultFactory() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public CompositeElement createComposite(IElementType type) {
            CompositeElement compositeElement;
            if (type instanceof IFileElementType) {
                compositeElement = new FileElement(type, null);
                if (compositeElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory$DefaultFactory.createComposite must not return null");
                return compositeElement;
            }
            compositeElement = new CompositeElement(type);
            if (compositeElement != null) return compositeElement;
            throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory$DefaultFactory.createComposite must not return null");
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public LeafElement createLeaf(IElementType type, CharSequence text) {
            LeafPsiElement leafPsiElement;
            Language lang = type.getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            if (parserDefinition != null && parserDefinition.getCommentTokens().contains(type)) {
                leafPsiElement = new PsiCommentImpl(type, text);
                if (leafPsiElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory$DefaultFactory.createLeaf must not return null");
                return leafPsiElement;
            }
            leafPsiElement = new LeafPsiElement(type, text);
            if (leafPsiElement != null) return leafPsiElement;
            throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory$DefaultFactory.createLeaf must not return null");
        }
    }
}

