/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javadoc;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.javadoc.JavadocConfiguration;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class JavadocGenerationManager
extends AbstractProjectComponent
implements JDOMExternalizable {
    private final JavadocConfiguration myConfiguration;

    public static JavadocGenerationManager getInstance(Project project) {
        return (JavadocGenerationManager)((Object)project.getComponent(JavadocGenerationManager.class));
    }

    JavadocGenerationManager(Project project) {
        super(project);
        this.myConfiguration = new JavadocConfiguration(project);
    }

    @NotNull
    public String getComponentName() {
        if ("JavadocGenerationManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/javadoc/JavadocGenerationManager.getComponentName must not return null");
        }
        return "JavadocGenerationManager";
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myConfiguration.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myConfiguration.writeExternal(element);
    }

    public JavadocConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    public void generateJavadoc(AnalysisScope scope, DataContext dataContext) {
        this.myConfiguration.setGenerationScope(scope);
        try {
            ProgramRunner runner = RunnerRegistry.getInstance().getRunner(DefaultRunExecutor.EXECUTOR_ID, (RunProfile)this.myConfiguration);
            assert (runner != null);
            runner.execute(DefaultRunExecutor.getRunExecutorInstance(), new ExecutionEnvironment((RunProfile)this.myConfiguration, dataContext));
        }
        catch (ExecutionException e) {
            ExecutionErrorDialog.show((ExecutionException)e, (String)CommonBundle.getErrorTitle(), (Project)this.myProject);
        }
    }
}

