/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javadoc;

import com.intellij.analysis.AnalysisScope;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLineStateUtil;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.BrowserUtil;
import com.intellij.javadoc.JavadocBundle;
import com.intellij.javadoc.JavadocConfigurable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.PathUtilEx;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootsTraversing;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavadocConfiguration
implements ModuleRunProfile,
JDOMExternalizable {
    public String OUTPUT_DIRECTORY;
    public String OPTION_SCOPE = "protected";
    public boolean OPTION_HIERARCHY = true;
    public boolean OPTION_NAVIGATOR = true;
    public boolean OPTION_INDEX = true;
    public boolean OPTION_SEPARATE_INDEX = true;
    public boolean OPTION_DOCUMENT_TAG_USE = false;
    public boolean OPTION_DOCUMENT_TAG_AUTHOR = false;
    public boolean OPTION_DOCUMENT_TAG_VERSION = false;
    public boolean OPTION_DOCUMENT_TAG_DEPRECATED = true;
    public boolean OPTION_DEPRECATED_LIST = true;
    public String OTHER_OPTIONS = "";
    public String HEAP_SIZE;
    public String LOCALE;
    public boolean OPEN_IN_BROWSER = true;
    private final Project myProject;
    private AnalysisScope myGenerationScope;

    public void setGenerationScope(AnalysisScope generationScope) {
        this.myGenerationScope = generationScope;
    }

    public JavadocConfiguration(Project project) {
        this.myProject = project;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/javadoc/JavadocConfiguration.getState must not be null");
        }
        if (env == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/javadoc/JavadocConfiguration.getState must not be null");
        }
        return new MyJavaCommandLineState(this.myProject, this.myGenerationScope);
    }

    public String getName() {
        return JavadocBundle.message("javadoc.settings.title", new Object[0]);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.myGenerationScope == null) {
            throw new RuntimeConfigurationError(JavadocBundle.message("javadoc.settings.not.specified", new Object[0]));
        }
    }

    public JavadocConfigurable createConfigurable() {
        return new JavadocConfigurable(this);
    }

    public Icon getIcon() {
        return null;
    }

    @NotNull
    public Module[] getModules() {
        if (Module.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/javadoc/JavadocConfiguration.getModules must not return null");
        }
        return Module.EMPTY_ARRAY;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    private static class MyContentIterator
    extends PsiRecursiveElementWalkingVisitor {
        private final PsiManager myPsiManager;
        private final Collection<String> myPackages;
        private final Collection<String> mySourceFiles;

        public MyContentIterator(Project project, Collection<String> packages, Collection<String> sources) {
            this.myPsiManager = PsiManager.getInstance((Project)project);
            this.myPackages = packages;
            this.mySourceFiles = sources;
        }

        public void visitFile(PsiFile file) {
            VirtualFile fileOrDir = file.getVirtualFile();
            if (fileOrDir == null) {
                return;
            }
            if (!fileOrDir.isInLocalFileSystem()) {
                return;
            }
            Module module = ModuleUtil.findModuleForFile((VirtualFile)fileOrDir, (Project)this.myPsiManager.getProject());
            if (file instanceof PsiJavaFile) {
                PsiJavaFile javaFile = (PsiJavaFile)file;
                if (MyContentIterator.containsPackagePrefix(module, javaFile.getPackageName())) {
                    this.mySourceFiles.add(PathUtil.getLocalPath((VirtualFile)javaFile.getVirtualFile()));
                } else {
                    this.myPackages.add(javaFile.getPackageName());
                }
            }
        }

        private static boolean containsPackagePrefix(Module module, String packageFQName) {
            ContentEntry[] contentEntries;
            if (module == null) {
                return false;
            }
            for (ContentEntry contentEntry : contentEntries = ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                SourceFolder[] sourceFolders;
                for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                    String packagePrefix = sourceFolder.getPackagePrefix();
                    int prefixLength = packagePrefix.length();
                    if (prefixLength <= 0 || !packageFQName.startsWith(packagePrefix)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class MyJavaCommandLineState
    extends CommandLineState {
        private final AnalysisScope myGenerationOptions;
        private final Project myProject;
        @NonNls
        private static final String INDEX_HTML = "index.html";

        public MyJavaCommandLineState(Project project, AnalysisScope generationOptions) {
            super(null);
            this.myGenerationOptions = generationOptions;
            this.myProject = project;
            TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
            builder.addFilter((Filter)new RegexpFilter(project, "$FILE_PATH$:$LINE$:[^\\^]+\\^"));
            builder.addFilter((Filter)new RegexpFilter(project, "$FILE_PATH$:$LINE$: warning - .+$"));
            this.setConsoleBuilder(builder);
        }

        protected GeneralCommandLine createCommandLine() throws ExecutionException {
            GeneralCommandLine cmdLine = new GeneralCommandLine();
            Sdk jdk = PathUtilEx.getAnyJdk(this.myProject);
            this.setupExeParams(jdk, cmdLine);
            this.setupProgramParameters(jdk, cmdLine);
            return cmdLine;
        }

        private void setupExeParams(Sdk jdk, GeneralCommandLine cmdLine) throws ExecutionException {
            String jdkPath;
            String string = jdkPath = jdk != null && jdk.getSdkType() instanceof JavaSdkType ? ((JavaSdkType)jdk.getSdkType()).getBinPath(jdk) : null;
            if (jdkPath == null) {
                throw new CantRunException(JavadocBundle.message("javadoc.generate.no.jdk.path", new Object[0]));
            }
            String versionString = jdk.getVersionString();
            if (JavadocConfiguration.this.HEAP_SIZE != null && JavadocConfiguration.this.HEAP_SIZE.trim().length() != 0) {
                if (versionString.indexOf("1.1") > -1) {
                    cmdLine.getParametersList().prepend("-J-mx" + JavadocConfiguration.this.HEAP_SIZE + "m");
                } else {
                    cmdLine.getParametersList().prepend("-J-Xmx" + JavadocConfiguration.this.HEAP_SIZE + "m");
                }
            }
            cmdLine.setWorkingDirectory(null);
            String javadocExecutableName = File.separator + (SystemInfo.isWindows ? "javadoc.exe" : "javadoc");
            String exePath = jdkPath.replace('/', File.separatorChar) + javadocExecutableName;
            if (new File(exePath).exists()) {
                cmdLine.setExePath(exePath);
            } else {
                File parent;
                exePath = new File(jdkPath).getParent().replace('/', File.separatorChar) + javadocExecutableName;
                if (!new File(exePath).exists() && !new File(exePath = (parent = new File(System.getProperty("java.home")).getParentFile()).getPath() + File.separator + "bin" + javadocExecutableName).exists()) {
                    throw new CantRunException(JavadocBundle.message("javadoc.generate.no.jdk.path", new Object[0]));
                }
                cmdLine.setExePath(exePath);
            }
        }

        private void setupProgramParameters(Sdk jdk, GeneralCommandLine cmdLine) throws CantRunException {
            String classPath;
            ParametersList parameters = cmdLine.getParametersList();
            if (JavadocConfiguration.this.LOCALE != null && JavadocConfiguration.this.LOCALE.length() > 0) {
                parameters.add("-locale");
                parameters.add(JavadocConfiguration.this.LOCALE);
            }
            if (JavadocConfiguration.this.OPTION_SCOPE != null) {
                parameters.add("-" + JavadocConfiguration.this.OPTION_SCOPE);
            }
            if (!JavadocConfiguration.this.OPTION_HIERARCHY) {
                parameters.add("-notree");
            }
            if (!JavadocConfiguration.this.OPTION_NAVIGATOR) {
                parameters.add("-nonavbar");
            }
            if (!JavadocConfiguration.this.OPTION_INDEX) {
                parameters.add("-noindex");
            } else if (JavadocConfiguration.this.OPTION_SEPARATE_INDEX) {
                parameters.add("-splitindex");
            }
            if (JavadocConfiguration.this.OPTION_DOCUMENT_TAG_USE) {
                parameters.add("-use");
            }
            if (JavadocConfiguration.this.OPTION_DOCUMENT_TAG_AUTHOR) {
                parameters.add("-author");
            }
            if (JavadocConfiguration.this.OPTION_DOCUMENT_TAG_VERSION) {
                parameters.add("-version");
            }
            if (!JavadocConfiguration.this.OPTION_DOCUMENT_TAG_DEPRECATED) {
                parameters.add("-nodeprecated");
            } else if (!JavadocConfiguration.this.OPTION_DEPRECATED_LIST) {
                parameters.add("-nodeprecatedlist");
            }
            parameters.addParametersString(JavadocConfiguration.this.OTHER_OPTIONS);
            String string = classPath = jdk.getSdkType() instanceof JavaSdk ? ProjectRootsTraversing.collectRoots((Project)this.myProject, (ProjectRootsTraversing.RootTraversePolicy)ProjectRootsTraversing.PROJECT_LIBRARIES).getPathsString() : ProjectRootsTraversing.collectRoots((Project)this.myProject, (ProjectRootsTraversing.RootTraversePolicy)ProjectRootsTraversing.LIBRARIES_AND_JDK).getPathsString();
            if (classPath.length() > 0) {
                parameters.add("-classpath");
                parameters.add(classPath);
            }
            parameters.add("-sourcepath");
            parameters.add(ProjectRootsTraversing.collectRoots((Project)this.myProject, (ProjectRootsTraversing.RootTraversePolicy)ProjectRootsTraversing.PROJECT_SOURCES).getPathsString());
            if (JavadocConfiguration.this.OUTPUT_DIRECTORY != null) {
                parameters.add("-d");
                parameters.add(JavadocConfiguration.this.OUTPUT_DIRECTORY.replace('/', File.separatorChar));
            }
            HashSet packages = new HashSet();
            HashSet sources = new HashSet();
            this.myGenerationOptions.accept((PsiElementVisitor)new MyContentIterator(this.myProject, (Collection<String>)packages, (Collection<String>)sources));
            if (packages.size() + sources.size() == 0) {
                throw new CantRunException(JavadocBundle.message("javadoc.generate.no.classes.in.selected.packages.error", new Object[0]));
            }
            parameters.addAll(new ArrayList(packages));
            parameters.addAll(new ArrayList(sources));
        }

        protected OSProcessHandler startProcess() throws ExecutionException {
            OSProcessHandler handler = JavaCommandLineStateUtil.startProcess((GeneralCommandLine)this.createCommandLine());
            ProcessTerminatedListener.attach((ProcessHandler)handler, (Project)this.myProject, (String)JavadocBundle.message("javadoc.generate.exited", new Object[0]));
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(ProcessEvent event) {
                    File url;
                    if (JavadocConfiguration.this.OPEN_IN_BROWSER && (url = new File(JavadocConfiguration.this.OUTPUT_DIRECTORY, MyJavaCommandLineState.INDEX_HTML)).exists() && event.getExitCode() == 0) {
                        BrowserUtil.launchBrowser((String)url.getPath());
                    }
                }
            });
            return handler;
        }
    }
}

