/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;

public class ToggleDumbModeAction
extends AnAction
implements DumbAware {
    private volatile boolean myDumb = false;

    public void actionPerformed(AnActionEvent e) {
        if (this.myDumb) {
            this.myDumb = false;
        } else {
            this.myDumb = true;
            Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
            if (project == null) {
                return;
            }
            CacheUpdater updater = new CacheUpdater(){

                public int getNumberOfPendingUpdateJobs() {
                    return 0;
                }

                public VirtualFile[] queryNeededFiles() {
                    while (ToggleDumbModeAction.this.myDumb) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    return VirtualFile.EMPTY_ARRAY;
                }

                public void processFile(FileContent fileContent) {
                }

                public void updatingDone() {
                }

                public void canceled() {
                }
            };
            DumbServiceImpl.getInstance(project).queueCacheUpdateInDumbMode(Arrays.asList(updater));
        }
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        presentation.setEnabled(project != null && this.myDumb == DumbServiceImpl.getInstance(project).isDumb());
        if (this.myDumb) {
            presentation.setText("Exit dumb mode");
        } else {
            presentation.setText("Enter dumb mode");
        }
    }
}

