/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public class SelectionModelWindow
implements SelectionModel {
    private final SelectionModel myHostModel;
    private final DocumentWindow myDocument;
    private final EditorWindow myInjectedEditor;

    public SelectionModelWindow(EditorEx delegate, DocumentWindow document, EditorWindow injectedEditor) {
        this.myDocument = document;
        this.myInjectedEditor = injectedEditor;
        this.myHostModel = delegate.getSelectionModel();
    }

    public int getSelectionStart() {
        return this.myDocument.hostToInjected(this.myHostModel.getSelectionStart());
    }

    public int getSelectionEnd() {
        return this.myDocument.hostToInjected(this.myHostModel.getSelectionEnd());
    }

    public String getSelectedText() {
        return this.myHostModel.getSelectedText();
    }

    public int getLeadSelectionOffset() {
        return this.myDocument.hostToInjected(this.myHostModel.getLeadSelectionOffset());
    }

    public boolean hasSelection() {
        return this.myHostModel.hasSelection();
    }

    public void setSelection(int startOffset, int endOffset) {
        TextRange hostRange = this.myDocument.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myHostModel.setSelection(hostRange.getStartOffset(), hostRange.getEndOffset());
    }

    public void removeSelection() {
        this.myHostModel.removeSelection();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.myHostModel.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.myHostModel.removeSelectionListener(listener);
    }

    public void selectLineAtCaret() {
        this.myHostModel.selectLineAtCaret();
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.myHostModel.selectWordAtCaret(honorCamelWordsSettings);
    }

    public void copySelectionToClipboard() {
        this.myHostModel.copySelectionToClipboard();
    }

    public void setBlockSelection(LogicalPosition blockStart, LogicalPosition blockEnd) {
        this.myHostModel.setBlockSelection(this.myInjectedEditor.injectedToHost(blockStart), this.myInjectedEditor.injectedToHost(blockEnd));
    }

    public void removeBlockSelection() {
        this.myHostModel.removeBlockSelection();
    }

    public boolean hasBlockSelection() {
        return this.myHostModel.hasBlockSelection();
    }

    @NotNull
    public int[] getBlockSelectionStarts() {
        int[] result = this.myHostModel.getBlockSelectionStarts();
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.myDocument.hostToInjected(result[i]);
        }
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/SelectionModelWindow.getBlockSelectionStarts must not return null");
        }
        return result;
    }

    @NotNull
    public int[] getBlockSelectionEnds() {
        int[] result = this.myHostModel.getBlockSelectionEnds();
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.myDocument.hostToInjected(result[i]);
        }
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/SelectionModelWindow.getBlockSelectionEnds must not return null");
        }
        return result;
    }

    public LogicalPosition getBlockStart() {
        return this.myInjectedEditor.hostToInjected(this.myHostModel.getBlockStart());
    }

    public LogicalPosition getBlockEnd() {
        return this.myInjectedEditor.hostToInjected(this.myHostModel.getBlockEnd());
    }

    public boolean isBlockSelectionGuarded() {
        return this.myHostModel.isBlockSelectionGuarded();
    }

    public RangeMarker getBlockSelectionGuard() {
        return this.myHostModel.getBlockSelectionGuard();
    }

    public TextAttributes getTextAttributes() {
        return this.myHostModel.getTextAttributes();
    }
}

