/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.ListenerWrapperMap;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;

public class CaretModelWindow
implements CaretModel {
    private final CaretModel myDelegate;
    private final EditorEx myHostEditor;
    private final EditorWindow myEditorWindow;
    private final ListenerWrapperMap<CaretListener> myCaretListeners = new ListenerWrapperMap();

    public CaretModelWindow(CaretModel delegate, EditorWindow editorWindow) {
        this.myDelegate = delegate;
        this.myHostEditor = (EditorEx)editorWindow.getDelegate();
        this.myEditorWindow = editorWindow;
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean blockSelection, boolean scrollToCaret) {
        this.myDelegate.moveCaretRelatively(columnShift, lineShift, withSelection, blockSelection, scrollToCaret);
    }

    public void moveToLogicalPosition(LogicalPosition pos) {
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(pos);
        this.myDelegate.moveToLogicalPosition(hostPos);
    }

    public void moveToVisualPosition(VisualPosition pos) {
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(this.myEditorWindow.visualToLogicalPosition(pos));
        this.myDelegate.moveToLogicalPosition(hostPos);
    }

    public void moveToOffset(int offset) {
        int hostOffset = this.myEditorWindow.getDocument().injectedToHost(offset);
        this.myDelegate.moveToOffset(hostOffset);
    }

    public LogicalPosition getLogicalPosition() {
        return this.myEditorWindow.hostToInjected(this.myHostEditor.offsetToLogicalPosition(this.myDelegate.getOffset()));
    }

    public VisualPosition getVisualPosition() {
        LogicalPosition logicalPosition = this.getLogicalPosition();
        return this.myEditorWindow.logicalToVisualPosition(logicalPosition);
    }

    public int getOffset() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getOffset());
    }

    public void addCaretListener(final CaretListener listener) {
        CaretListener wrapper = new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                CaretEvent event = new CaretEvent((Editor)CaretModelWindow.this.myEditorWindow, CaretModelWindow.this.myEditorWindow.hostToInjected(e.getOldPosition()), CaretModelWindow.this.myEditorWindow.hostToInjected(e.getNewPosition()));
                listener.caretPositionChanged(event);
            }
        };
        this.myCaretListeners.registerWrapper(listener, wrapper);
        this.myDelegate.addCaretListener(wrapper);
    }

    public void removeCaretListener(CaretListener listener) {
        CaretListener wrapper = this.myCaretListeners.removeWrapper(listener);
        if (wrapper != null) {
            this.myDelegate.removeCaretListener(wrapper);
        }
    }

    public void disposeModel() {
        for (CaretListener wrapper : this.myCaretListeners.wrappers()) {
            this.myDelegate.removeCaretListener(wrapper);
        }
        this.myCaretListeners.clear();
    }

    public int getVisualLineStart() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getVisualLineStart());
    }

    public int getVisualLineEnd() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getVisualLineEnd());
    }

    public TextAttributes getTextAttributes() {
        return this.myDelegate.getTextAttributes();
    }
}

